/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.httpclient.lib;

import com.remainsoftware.common.ssl.CertificateUtils;
import com.remainsoftware.common.ssl.CustomTrustManagerUtils;
import com.remainsoftware.common.ssl.CustomX509TrustManager;
import com.remainsoftware.common.util.NetUtils;
import com.remainsoftware.common.util.ProxyInfo;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static boolean isHttpsProxy = Boolean.getBoolean("omx.httpsProxy");
    private static int defaultTimeout = 300;

    public static CloseableHttpClient getApacheDefaultHttpsClient() throws IOException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        try {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClientUtils.getCustomSslSocketFactory());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return builder.build();
    }

    public static CloseableHttpClient getApacheHttpClient(URI uri) {
        return HttpClientUtils.getApacheHttpClient(uri, null);
    }

    public static CloseableHttpClient getApacheHttpClient(URI uri, HttpClientConnectionManager connectionManager) {
        Validate.isNotNull((Object)uri, (String)"URI must be set");
        try {
            return HttpClientUtils.createHttpClient(uri, connectionManager);
        }
        catch (Exception e) {
            logger.error("Creating HttpClient with customized SSL certificate handler failed, action = returning default http client, cause = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            HttpClientBuilder clientBuilder = HttpClients.custom();
            clientBuilder.setMaxConnTotal(100);
            clientBuilder.setMaxConnPerRoute(100);
            RequestConfig config = RequestConfig.custom().setRedirectsEnabled(true).setMaxRedirects(5).setConnectTimeout(defaultTimeout * 1000).setConnectionRequestTimeout(defaultTimeout * 1000).setSocketTimeout(defaultTimeout * 1000).build();
            clientBuilder.setDefaultRequestConfig(config);
            return clientBuilder.build();
        }
    }

    static CloseableHttpClient createHttpClient(URI uri) throws Exception {
        return HttpClientUtils.createHttpClient(uri, null);
    }

    static CloseableHttpClient createHttpClient(URI uri, HttpClientConnectionManager connectionManager) throws Exception {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setMaxConnTotal(200);
        ProxyInfo proxyData = NetUtils.getProxyInfo((URI)uri);
        if (proxyData != null) {
            HttpHost proxy = new HttpHost(proxyData.getProxyHost(), proxyData.getProxyPort(), isHttpsProxy ? "https" : "http");
            RequestConfig config = RequestConfig.custom().setProxy(proxy).setRedirectsEnabled(true).setMaxRedirects(5).setConnectTimeout(defaultTimeout * 1000).setConnectionRequestTimeout(defaultTimeout * 1000).setSocketTimeout(defaultTimeout * 1000).build();
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            if (proxyData.isProxyUserSet()) {
                UsernamePasswordCredentials credentials = null;
                BasicCredentialsProvider credentialProvider = new BasicCredentialsProvider();
                AuthScope authscope = new AuthScope(proxyData.getProxyHost(), proxyData.getProxyPort());
                if (proxyData.isProxyDomainSet()) {
                    String localHost = "localhost";
                    try {
                        localHost = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    catch (Throwable e) {
                        logger.error("Failed to get local host name, using 'localhost'", e);
                    }
                    credentials = new NTCredentials(proxyData.getProxyUser(), proxyData.getProxyPassword(), localHost, proxyData.getProxyDomain());
                    credentialProvider.setCredentials(authscope, (Credentials)credentials);
                } else {
                    credentials = new UsernamePasswordCredentials(proxyData.getProxyUser(), proxyData.getProxyPassword());
                }
                credentialProvider.setCredentials(authscope, (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialProvider);
            }
            clientBuilder.setDefaultRequestConfig(config);
        } else {
            RequestConfig config = RequestConfig.custom().setRedirectsEnabled(true).setMaxRedirects(5).setConnectTimeout(defaultTimeout * 1000).setConnectionRequestTimeout(defaultTimeout * 1000).setSocketTimeout(defaultTimeout * 1000).build();
            clientBuilder.setDefaultRequestConfig(config);
        }
        clientBuilder.setMaxConnTotal(100);
        clientBuilder.setMaxConnPerRoute(50);
        if (connectionManager != null) {
            clientBuilder.setConnectionManager(connectionManager);
        }
        clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClientUtils.getCustomSslSocketFactory());
        return clientBuilder.build();
    }

    private static SSLConnectionSocketFactory getCustomSslSocketFactory() throws Exception {
        X509TrustManager customTrustMgr = CustomTrustManagerUtils.getCustomTrustManagerInstance();
        if (customTrustMgr == null) {
            customTrustMgr = new CustomX509TrustManager();
        }
        X509HostnameVerifier hostVerifier = HttpClientUtils.getCustomHostVerifier();
        SSLContext sslContext = SSLContext.getInstance(CertificateUtils.getDefaultSSLContextProtocol());
        sslContext.init(null, new TrustManager[]{customTrustMgr}, null);
        return new SSLConnectionSocketFactory(sslContext, CertificateUtils.getSupportedSSLProtocols(), null, hostVerifier);
    }

    public static X509HostnameVerifier getCustomHostVerifier() throws Exception {
        X509HostnameVerifier hostVerifier = new X509HostnameVerifier(){

            public boolean verify(String hostName, SSLSession ssls) {
                if (CertificateUtils.isTrustedHost((String)hostName)) {
                    return true;
                }
                logger.warn("failed to trust host: '" + hostName + "', reason = host is not listed as trusted");
                return false;
            }

            public void verify(String arg0, SSLSocket arg1) throws IOException {
            }

            public void verify(String arg0, X509Certificate arg1) throws SSLException {
            }

            public void verify(String arg0, String[] arg1, String[] arg2) throws SSLException {
            }
        };
        return hostVerifier;
    }

    public void main(String[] args) {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(100);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)cm).build();
            HttpGet httpGet = new HttpGet("https://token-host:8243/token");
            httpclient.execute((HttpUriRequest)httpGet);
            String json = " {\"data\":\"grant_type=password&username=test&password=test123\"}";
            HttpPost httpPost = new HttpPost("https:/request-host:443");
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("Authorization", "Basic ?auth-text-from-response?");
            httpPost.setEntity((HttpEntity)new StringEntity(json));
            httpPost.expectContinue();
            httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

