/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.connection.impl;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.MemberList;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectList;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.UserSpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;

public class DefaultConnectionUtilities
implements IConnectionUtilities {
    private static final String QGPL = "QGPL";
    private static final String EMPTY = "";
    private Debug logger = Debug.getInstance();

    @Override
    public void executeRemoteCommand(IConnection connection, String command) {
        this.logger.debug((Option)miworkplace.connection.debug.Option.connection, "Executing remote command: " + command);
        CommandCall cmdCall = new CommandCall(connection.getSystem(), command);
        boolean success = false;
        try {
            success = cmdCall.run();
        }
        catch (Exception e) {
            this.logger.error("Error during remote command execution. Command: " + command, (Throwable)e);
        }
        if (!success) {
            StringBuilder msg = new StringBuilder();
            try {
                AS400Message[] messagelist;
                AS400Message[] aS400MessageArray = messagelist = cmdCall.getMessageList();
                int n = messagelist.length;
                int n2 = 0;
                while (n2 < n) {
                    AS400Message element = aS400MessageArray[n2];
                    msg.append(element.getText() + System.lineSeparator());
                    ++n2;
                }
            }
            catch (Exception e) {
                this.logger.error("Error during remote command execution. Command: " + command, (Throwable)e);
                throw e;
            }
            throw new RuntimeException(String.format(Messages.connutil_execcmd_error, msg.toString()));
        }
    }

    @Override
    public boolean doesObjectExist(IConnection conn, String path) {
        boolean exist = false;
        if (!conn.isConnected()) {
            this.logger.error((Option)miworkplace.connection.debug.Option.connection, "System is not connected.");
        }
        QSYSObjectPathName qsysPathName = new QSYSObjectPathName(path);
        ObjectList oList = new ObjectList(conn.getSystem(), qsysPathName.getLibraryName(), qsysPathName.getObjectName(), "*" + qsysPathName.getObjectType());
        try {
            oList.load();
            exist = oList.getLength() != 0;
        }
        catch (AS400Exception ase) {
            if (ase.getAS400Message().getID().equals("CPF9810")) {
                return false;
            }
            throw new RuntimeException(String.format(Messages.connutil_execcmd_error, path), ase);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Messages.connutil_execcmd_error, path), e);
        }
        return exist;
    }

    @Override
    public List<String> getLibraryList(IConnection connection) {
        Job[] jobs = connection.getSystem().getJobs(2);
        if (jobs.length == 0) {
            try {
                connection.getSystem().connectService(2);
                jobs = connection.getSystem().getJobs(2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.connutil_connect_error, e);
            }
        }
        try {
            Job serverJob = new CommandCall(connection.getSystem()).getServerJob();
            String[] libraryList = serverJob.getUserLibraryList();
            LinkedList<String> libraries = new LinkedList<String>(Arrays.asList(libraryList));
            if (serverJob.getCurrentLibraryExistence()) {
                libraries.add(serverJob.getCurrentLibrary());
            }
            return libraries;
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.connutil_retrieve_libl_error, e);
        }
    }

    @Override
    public void createSourceFile(IConnection connection, String sourceFileName, String descriptionText, String libraryName, int sourceLength) {
        if (!connection.isConnected()) {
            throw new RuntimeException(String.format(Messages.connutil_connectto_error, connection.getSystemName()));
        }
        String command = "CRTSRCPF FILE(" + libraryName + "/" + sourceFileName + ") RCDLEN(" + String.valueOf(sourceLength) + ") MBR(*NONE) TEXT('" + descriptionText + "')";
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void deleteObject(IConnection connection, String libraryName, String objectName, String type) {
        String command = null;
        if (type.equals("*FILE")) {
            command = "DLTF FILE(" + libraryName + "/" + objectName + ")";
        } else if (type.equals("*PGM")) {
            command = "DLTPGM PGM(" + libraryName + "/" + objectName + ")";
        } else if (type.equals("*SRVPGM")) {
            command = "DLTSRVPGM SRVPGM(" + libraryName + "/" + objectName + ")";
        } else if (type.equals("*MODULE")) {
            command = "DLTMOD MODULE(" + libraryName + "/" + objectName + ")";
        } else if (type.equals("*DTAARA")) {
            command = "DLTDTAARA DTAARA(" + libraryName + "/" + objectName + ")";
        } else if (type.equals("*USRSPC")) {
            command = "DLTUSRSPC USRSPC(" + libraryName + "/" + objectName + ")";
        } else if (type.equals("*BNDDIR")) {
            command = "DLTBNDDIR BNDDDIR(" + libraryName + "/" + objectName + ")";
        } else if (type.equals("*WSCST")) {
            command = "DLTWSCST WSCST(" + libraryName + "/" + objectName + ")";
        } else {
            String errorMessage = String.format(Messages.connutil_delete_objtype_notsupported, type);
            RuntimeException runtimeException = new RuntimeException(errorMessage);
            this.logger.error(errorMessage, (Throwable)runtimeException);
            throw runtimeException;
        }
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void createSourceMember(IConnection connection, String libraryName, String sourceFileName, String memberName, String attribute, String descriptionText) {
        String command = "ADDPFM FILE(" + libraryName + "/" + sourceFileName + ") MBR(" + memberName + ") SRCTYPE(" + attribute + ") TEXT('" + descriptionText + "')";
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void deleteSourceMember(IConnection connection, String libraryName, String sourceFileName, String memberName) {
        String command = "RMVM FILE(" + libraryName + "/" + sourceFileName + ") MBR(" + memberName + ")";
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void deleteSourceMember(IConnection connection, String ifs) {
        QSYSObjectPathName path = new QSYSObjectPathName(ifs);
        this.deleteSourceMember(connection, path.getLibraryName(), path.getObjectName(), path.getMemberName());
    }

    @Override
    public boolean isMemberLocked(IConnection connection, String memberPath, String parmLockState) throws Exception {
        return this.isMemberLocked(connection, memberPath, new String[]{parmLockState});
    }

    @Override
    public boolean isMemberLocked(IConnection connection, String memberPath, String[] parmLockStates) throws Exception {
        boolean locked;
        block12: {
            locked = false;
            List<String> lockStates = Arrays.asList(parmLockStates);
            UserSpace us = new UserSpace(connection.getSystem(), QSYSObjectPathName.toPath((String)"QTEMP", (String)"QWCLOBJL", (String)"USRSPC"));
            us.setMustUseProgramCall(true);
            try {
                us.create(65535, true, "MIWORKPLAC", (byte)0, "Userspace for MiWorkplace loading object locks", "*ALL");
            }
            catch (Exception use) {
                throw new RuntimeException(Messages.connutil_member_lock_error, use);
            }
            byte[] byteArr = new byte[4];
            byte[] userSpaceBytes = new byte[65535];
            int entrySize = 0;
            int listPosition = 0;
            int listEntries = 0;
            int userspacePosition = 0;
            int userspaceOffset = 0;
            int entryPosition = 0;
            AS400Bin4 as400Binary = new AS400Bin4();
            CharConverter conv = null;
            ProgramCall program = new ProgramCall(connection.getSystem());
            String programName = "/QSYS.LIB/QWCLOBJL.PGM";
            ProgramParameter[] parameterList = new ProgramParameter[6];
            AS400Text text = new AS400Text(20, connection.getSystem());
            QSYSObjectPathName path = new QSYSObjectPathName(memberPath);
            QSYSObjectPathName usPath = new QSYSObjectPathName("QTEMP", "QWCLOBJL", "USRSPC");
            parameterList[0] = new ProgramParameter(text.toBytes((Object)usPath.toQualifiedObjectName()));
            parameterList[1] = new ProgramParameter(text.toBytes((Object)"OBJL0100"));
            parameterList[2] = new ProgramParameter(text.toBytes((Object)path.toQualifiedObjectName()));
            parameterList[3] = new ProgramParameter(text.toBytes((Object)"*FILE     "));
            parameterList[4] = new ProgramParameter(text.toBytes((Object)path.getMemberName()));
            parameterList[5] = new ProgramParameter(300);
            try {
                program.setProgram(programName);
                program.setParameterList(parameterList);
                if (us.exists() && program.run()) {
                    try {
                        us.read(userSpaceBytes, userspacePosition);
                        conv = new CharConverter(connection.getSystem().getCcsid(), connection.getSystem());
                    }
                    catch (Exception e) {
                        throw new Exception(Messages.connutil_member_lock_us_error, e);
                    }
                    System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
                    listPosition = as400Binary.toInt(byteArr);
                    System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
                    listEntries = as400Binary.toInt(byteArr);
                    System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
                    entrySize = as400Binary.toInt(byteArr);
                    userspaceOffset = listPosition;
                    int i = 0;
                    while (i < listEntries) {
                        try {
                            if (entryPosition * entrySize + entrySize + userspaceOffset > userSpaceBytes.length) {
                                userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                                userspaceOffset = 0;
                                entryPosition = 0;
                            }
                            String lockType = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 26 + userspaceOffset, 10).trim();
                            locked = lockStates.contains(lockType);
                        }
                        catch (Exception e) {
                            throw new Exception(Messages.connutil_member_lock_retrieval_error, e);
                        }
                        ++entryPosition;
                        ++i;
                    }
                    us.delete();
                    break block12;
                }
                AS400Message[] msgList = program.getMessageList();
                StringBuilder as400ErrorMsg = new StringBuilder();
                AS400Message[] aS400MessageArray = msgList;
                int n = msgList.length;
                int n2 = 0;
                while (n2 < n) {
                    AS400Message element = aS400MessageArray[n2];
                    this.logger.debug((Option)miworkplace.connection.debug.Option.connection, element.getText());
                    as400ErrorMsg.append(element.getID() + " - " + element.getText() + " ");
                    ++n2;
                }
                throw new Exception(String.format(Messages.connutil_member_lock_pgm_error, as400ErrorMsg.toString()));
            }
            catch (Exception e) {
                throw new Exception(Messages.connutil_member_lock_error, e);
            }
        }
        return locked;
    }

    @Override
    public Collection<String> listMemberLockJobs(IConnection connection, String memberPath) {
        HashSet<String> jobNames = new HashSet<String>();
        UserSpace us = new UserSpace(connection.getSystem(), QSYSObjectPathName.toPath((String)"QTEMP", (String)"QWCLOBJL", (String)"USRSPC"));
        us.setMustUseProgramCall(true);
        try {
            us.create(65535, true, "MIWORKPLAC", (byte)0, "Userspace for MiWorkplace loading object locks", "*ALL");
        }
        catch (Exception use) {
            throw new RuntimeException(Messages.connutil_member_lock_error, use);
        }
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        AS400Bin4 as400Binary = new AS400Bin4();
        CharConverter conv = null;
        ProgramCall program = new ProgramCall(connection.getSystem());
        String programName = "/QSYS.LIB/QWCLOBJL.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[6];
        AS400Text text = new AS400Text(20, connection.getSystem());
        QSYSObjectPathName path = new QSYSObjectPathName(memberPath);
        QSYSObjectPathName usPath = new QSYSObjectPathName("QTEMP", "QWCLOBJL", "USRSPC");
        parameterList[0] = new ProgramParameter(text.toBytes((Object)usPath.toQualifiedObjectName()));
        parameterList[1] = new ProgramParameter(text.toBytes((Object)"OBJL0100"));
        parameterList[2] = new ProgramParameter(text.toBytes((Object)path.toQualifiedObjectName()));
        parameterList[3] = new ProgramParameter(text.toBytes((Object)"*FILE     "));
        parameterList[4] = new ProgramParameter(text.toBytes((Object)path.getMemberName()));
        parameterList[5] = new ProgramParameter(300);
        try {
            program.setProgram(programName);
            program.setParameterList(parameterList);
            if (us.exists() && program.run()) {
                try {
                    us.read(userSpaceBytes, userspacePosition);
                    conv = new CharConverter(connection.getSystem().getCcsid(), connection.getSystem());
                }
                catch (Exception e) {
                    throw new RuntimeException(Messages.connutil_member_lock_us_error, e);
                }
                System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
                listPosition = as400Binary.toInt(byteArr);
                System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
                listEntries = as400Binary.toInt(byteArr);
                System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
                entrySize = as400Binary.toInt(byteArr);
                userspaceOffset = listPosition;
                int i = 0;
                while (i < listEntries) {
                    try {
                        if (entryPosition * entrySize + entrySize + userspaceOffset > userSpaceBytes.length) {
                            userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                            userspaceOffset = 0;
                            entryPosition = 0;
                        }
                        String name = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 0 + userspaceOffset, 10).trim();
                        String user = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 10 + userspaceOffset, 10).trim();
                        String number = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 20 + userspaceOffset, 6).trim();
                        String qualifiedJobName = name + "/" + user + "/" + number;
                        jobNames.add(qualifiedJobName);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(Messages.connutil_member_lock_error, e);
                    }
                    ++entryPosition;
                    ++i;
                }
                us.delete();
                return jobNames;
            }
            AS400Message[] msgList = program.getMessageList();
            StringBuilder as400ErrorMsg = new StringBuilder();
            AS400Message[] aS400MessageArray = msgList;
            int n = msgList.length;
            int n2 = 0;
            while (n2 < n) {
                AS400Message element = aS400MessageArray[n2];
                as400ErrorMsg.append(element.getID() + " - " + element.getText() + " ");
                ++n2;
            }
            throw new RuntimeException(String.format(Messages.connutil_member_lock_pgm_error, as400ErrorMsg.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.connutil_member_lock_retrieval_error, e);
        }
    }

    @Override
    public void copyMember(IConnection connection, String from, String to) {
        QSYSObjectPathName fromPath = new QSYSObjectPathName(from);
        QSYSObjectPathName toPath = new QSYSObjectPathName(to);
        String command = "CPYF FROMFILE(" + fromPath.getLibraryName() + "/" + fromPath.getObjectName() + ") TOFILE(" + toPath.getLibraryName() + "/" + toPath.getObjectName() + ") FROMMBR(" + fromPath.getMemberName() + ") TOMBR(" + toPath.getMemberName() + ") MBROPT(*ADD) CRTFILE(*YES) FMTOPT(*MAP *DROP)";
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void renameLibrary(IConnection connection, String ifsPath, String newName) {
        this.renameObject(connection, ifsPath, newName);
    }

    @Override
    public void renameObject(IConnection connection, String ifsPath, String newName) {
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        String command = MessageFormat.format("RNMOBJ OBJ({0}/{1}) OBJTYPE(*{2}) NEWOBJ({3})", path.getLibraryName().trim(), path.getObjectName().trim(), path.getObjectType(), newName);
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void renameMember(IConnection connection, String ifsPath, String newMemberName) {
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        String command = MessageFormat.format("RNMM FILE({0}/{1}) MBR({2}) NEWMBR({3})", path.getLibraryName().trim(), path.getObjectName().trim(), path.getMemberName().trim(), newMemberName);
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public boolean doesMemberExist(IConnection connection, String path) {
        boolean exist = false;
        QSYSObjectPathName qsysPathName = new QSYSObjectPathName(path);
        MemberList mList = new MemberList(connection.getSystem(), qsysPathName);
        mList.addAttribute(3);
        try {
            mList.load();
            exist = mList.getMemberDescriptions().length != 0;
        }
        catch (AS400Exception ase) {
            if (ase.getAS400Message().getID().equals("CPF9810")) {
                return false;
            }
            throw new RuntimeException(String.format(Messages.connutil_member_check_error, path), ase);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Messages.connutil_member_check_error, path), e);
        }
        return exist;
    }

    @Override
    public void copySourceFile(IConnection connection, String from, String to) {
        QSYSObjectPathName fromPath = new QSYSObjectPathName(from);
        QSYSObjectPathName toPath = new QSYSObjectPathName(to);
        if (this.doesObjectExist(connection, to)) {
            this.deleteObject(connection, toPath.getLibraryName(), toPath.getObjectName(), "*" + toPath.getObjectType());
        }
        if (toPath.getObjectType().equals("FILE")) {
            ObjectDescription description = new ObjectDescription(connection.getSystem(), fromPath);
            String attribute = null;
            try {
                attribute = description.getValueAsString(202);
            }
            catch (Exception e) {
                this.logger.error("Could not determine extended attribute for " + fromPath.toString(), (Throwable)e);
                return;
            }
            if ("LF".equals(attribute)) {
                throw new RuntimeException("Copying LF not supported.");
            }
            String command = MessageFormat.format("CPYF FROMFILE({0}/{1}) TOFILE({2}/{3}) FROMMBR(*ALL) TOMBR(*FROMMBR) MBROPT(*ADD) CRTFILE(*YES)", fromPath.getLibraryName(), fromPath.getObjectName(), toPath.getLibraryName(), toPath.getObjectName());
            this.executeRemoteCommand(connection, command);
        } else {
            String command = MessageFormat.format("CPY OBJ(''{0}'') TOOBJ(''{1}'') OWNER(*KEEP)", from, to);
            this.executeRemoteCommand(connection, command);
        }
    }

    @Override
    public void changeObjectDescription(IConnection connection, String ifsPath, String description) {
        if (((String)description).length() > 50) {
            description = ((String)description).substring(0, 47) + "...";
        }
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        String command = MessageFormat.format("CHGOBJD OBJ({0}/{1}) OBJTYPE(*{2}) TEXT(''{3}'')", path.getLibraryName().trim(), path.getObjectName().trim(), path.getObjectType(), description);
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void changeMemberDescription(IConnection connection, String ifsPath, String description) {
        if (((String)description).length() > 50) {
            description = ((String)description).substring(0, 47) + "...";
        }
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        String command = MessageFormat.format("CHGPFM FILE({0}/{1}) MBR({2}) TEXT(''{3}'')", path.getLibraryName().trim(), path.getObjectName().trim(), path.getMemberName(), description);
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void changeMemberType(IConnection connection, String ifsPath, String type) {
        if (type.length() > 10) {
            type = type.substring(0, 10);
        }
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        String command = MessageFormat.format("CHGPFM FILE({0}/{1}) MBR({2}) SRCTYPE({3})", path.getLibraryName().trim(), path.getObjectName().trim(), path.getMemberName(), type);
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void deleteStreamFile(IConnection connection, String ifsPath) {
        IFSFile file = new IFSFile(connection.getSystem(), ifsPath);
        try {
            if (file.exists()) {
                if (file.isDirectory()) {
                    String command = MessageFormat.format("RMVDIR DIR(''{0}'') SUBTREE(*ALL)", ifsPath);
                    this.executeRemoteCommand(connection, command);
                } else {
                    boolean deleted = file.delete();
                    if (!deleted) {
                        if (file.canWrite()) {
                            throw new RuntimeException(String.format(Messages.connutil_delete_stmf_error, ifsPath));
                        }
                        throw new RuntimeException(String.format(Messages.connutil_delete_stmf_nowrite_error, ifsPath));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format(Messages.connutil_delete_stmf_error, ifsPath), e);
        }
    }

    @Override
    public void clearMember(IConnection connection, String ifsPath) {
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        String command = MessageFormat.format("CLRPFM FILE({0}/{1}) MBR({2})", path.getLibraryName(), path.getObjectName(), path.getMemberName());
        this.executeRemoteCommand(connection, command);
    }

    @Override
    public void addLibraryToLibraryList(IConnection connection, String library) {
        library = library.toUpperCase();
        Job[] jobs = connection.getSystem().getJobs(2);
        try {
            String[] userLibraryList = jobs[0].getUserLibraryList();
            if (userLibraryList != null) {
                String[] stringArray = userLibraryList;
                int n = userLibraryList.length;
                int n2 = 0;
                while (n2 < n) {
                    String lib = stringArray[n2];
                    if (lib.equals(library)) {
                        this.logger.info((Option)miworkplace.connection.debug.Option.connection, "Could not add custom library to user library list. Library already in list. Library: " + library);
                        return;
                    }
                    ++n2;
                }
            }
            this.executeRemoteCommand(connection, MessageFormat.format("ADDLIBLE {0}", library));
        }
        catch (Exception e) {
            this.logger.error("Could not add library to user library list. Library: " + library, (Throwable)e);
        }
    }

    @Override
    public void setUserLibraryList(IConnection connection, String[] libraries) {
        if (libraries == null || libraries.length == 0) {
            return;
        }
        StringBuilder command = new StringBuilder("CHGLIBL LIBL(");
        String[] stringArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            lib = lib.toUpperCase();
            command.append(lib);
            command.append(" ");
            ++n2;
        }
        command.append(")");
        this.executeRemoteCommand(connection, command.toString());
    }

    @Override
    public StringBuilder loadIFSFile(IConnection pConnection, String pIfsPath, Writer pWriter) throws IOException, SecurityException {
        IFSFile file = new IFSFile(pConnection.getSystem(), pIfsPath);
        if (!file.canRead()) {
            throw new SecurityException("Can't read IFS file " + pIfsPath);
        }
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedReader in = new BufferedReader((Reader)new IFSFileReader(file));){
                StringBuilder sb = new StringBuilder(4096);
                char[] buffer = new char[4096];
                int size = 0;
                while ((size = in.read(buffer)) > 0) {
                    sb.append(buffer, 0, size);
                    if (pWriter == null) continue;
                    pWriter.write(buffer, 0, size);
                }
                return sb;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (AS400SecurityException e) {
            throw new SecurityException(e.getMessage(), e);
        }
        catch (IOException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    @Override
    public String getCurrentLibrary(IConnection pConnection) {
        try {
            String currentLibrary = new CommandCall(pConnection.getSystem()).getServerJob().getCurrentLibrary();
            if (currentLibrary.equals(EMPTY)) {
                currentLibrary = QGPL;
            }
            return currentLibrary;
        }
        catch (Exception e) {
            this.logger.error("Could not retrieve the current library for the job.", (Throwable)e);
            return QGPL;
        }
    }
}

