/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import miworkplace.i18n.Messages;
import miworkplace.ui.pref.SimplePreferencePage;
import miworkplace.ui.pref.api.FilePreference;
import miworkplace.ui.pref.api.PasswordPreference;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.PreferencePage;
import miworkplace.ui.pref.api.SelectionPreference;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PreferencePageBuilder {
    public PreferencePage buildPreferencePage(IEclipsePreferences preferences, PreferenceNode selection, Composite contentArea) {
        SimplePreferencePage page = new SimplePreferencePage(contentArea, 0);
        page.setLayout((Layout)new FillLayout());
        FormToolkit toolkit = new FormToolkit(page.getDisplay());
        Form form = toolkit.createForm((Composite)page);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 20;
        layout.bottomMargin = 20;
        layout.leftMargin = 25;
        layout.rightMargin = 25;
        layout.numColumns = 3;
        layout.horizontalSpacing = 15;
        form.getBody().setLayout((Layout)layout);
        form.setText(selection.getName());
        this.buildPreferences(toolkit, form, selection, preferences);
        return page;
    }

    private void buildPreferences(FormToolkit toolkit, final Form form, PreferenceNode selection, IEclipsePreferences preferenceStore) {
        Label c = null;
        Text fieldAssistTarget = null;
        LinkedList<Preference> preferences = new LinkedList<Preference>(selection.getPreferences());
        Collections.sort(preferences, new Comparator<Preference>(){

            @Override
            public int compare(Preference p1, Preference p2) {
                return p1.getOrder() - p2.getOrder();
            }
        });
        if (selection.getDescription() != null) {
            c = toolkit.createLabel(form.getBody(), selection.getDescription(), 64);
            TableWrapData layoutData = new TableWrapData(256);
            layoutData.colspan = 3;
            c.setLayoutData((Object)layoutData);
        }
        for (Preference p : preferences) {
            TableWrapData layoutData = new TableWrapData();
            layoutData.valign = 32;
            Label l = null;
            l = toolkit.createLabel(form.getBody(), p.getName() + ":");
            l.setLayoutData((Object)layoutData);
            layoutData = new TableWrapData();
            layoutData.colspan = 2;
            layoutData.grabHorizontal = true;
            Text formField = null;
            if (p.getType() == String.class) {
                formField = p instanceof PasswordPreference ? toolkit.createText(form.getBody(), p.getValue(), 0x400800) : toolkit.createText(form.getBody(), p.getValue(), 2048);
                formField.setText(preferenceStore.get(p.getId(), p.getValue()));
                layoutData.maxWidth = p.getWidth() == null ? 100 : p.getWidth();
                formField.setLayoutData((Object)layoutData);
                fieldAssistTarget = l;
            } else if (p.getType() == Boolean.class) {
                formField = toolkit.createButton(form.getBody(), null, 32);
                ((Button)formField).setSelection(preferenceStore.getBoolean(p.getId(), Boolean.valueOf(p.getValue()).booleanValue()));
                formField.setLayoutData((Object)layoutData);
                fieldAssistTarget = formField;
            } else if (p.getType() == Integer.class) {
                formField = toolkit.createText(form.getBody(), p.getValue(), 2048);
                formField.setText(preferenceStore.get(p.getId(), p.getValue()));
                layoutData.maxWidth = p.getWidth() == null ? 100 : p.getWidth();
                formField.setLayoutData((Object)layoutData);
                fieldAssistTarget = l;
            } else if (p.getType() == File.class) {
                final Text filenameTarget = toolkit.createText(form.getBody(), p.getValue(), 2048);
                String id = p.getId();
                String idValue = p.getValue();
                if (id != null && idValue != null) {
                    filenameTarget.setText(preferenceStore.get(id, idValue));
                } else {
                    filenameTarget.setText("");
                }
                layoutData.colspan = 1;
                layoutData.maxWidth = p.getWidth() == null ? 250 : p.getWidth();
                filenameTarget.setLayoutData((Object)layoutData);
                formField = filenameTarget;
                final String[] filterExtensions = p instanceof FilePreference ? ((FilePreference)p).getFilterExtensions() : null;
                final boolean selectFolder = p instanceof FilePreference ? ((FilePreference)p).selectFolder() : false;
                TableWrapData scndLayoutData = new TableWrapData();
                scndLayoutData.valign = 32;
                Button browse = toolkit.createButton(form.getBody(), Messages.pref_page_browse, 8);
                browse.setLayoutData((Object)scndLayoutData);
                browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (selectFolder) {
                            DirectoryDialog dialog = new DirectoryDialog(form.getShell(), 4096);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                filenameTarget.setText(filePath);
                            }
                        } else {
                            FileDialog dialog = new FileDialog(form.getShell(), 4096);
                            dialog.setFilterExtensions(filterExtensions);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                filenameTarget.setText(filePath);
                            }
                        }
                    }
                });
                fieldAssistTarget = l;
            } else if (p.getType() == Set.class) {
                CCombo combobox = new CCombo(form.getBody(), 0x800800);
                combobox.setEditable(false);
                toolkit.adapt((Composite)combobox);
                toolkit.paintBordersFor((Composite)combobox);
                Set<String> suggestions = ((SelectionPreference)p).getSuggestions();
                String[] values = suggestions.toArray(new String[suggestions.size()]);
                combobox.setItems(values);
                combobox.setLayoutData((Object)layoutData);
                String value = preferenceStore.get(p.getId(), p.getValue());
                combobox.select(combobox.indexOf(value));
                formField = combobox;
            }
            if (p.getDescription() != null) {
                this.setFieldAssist((Control)fieldAssistTarget, p);
            }
            formField.setData("preference", (Object)p);
            c = formField;
        }
    }

    private void setFieldAssist(Control widget, Preference p) {
        if (widget == null) {
            return;
        }
        ControlDecoration deco = new ControlDecoration(widget, 16512);
        Display device = Display.getCurrent();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("/icons/information.gif");
        Image image = new Image((Device)device, in);
        deco.setImage(image);
        deco.setDescriptionText(p.getDescription());
        deco.setShowOnlyOnFocus(false);
    }
}

