/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;

public class SignAndVerifyDataFileTest {
    private static void writeBinary(OutputStream out, Key key) throws IOException {
        out.write(key.getEncoded());
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("verify digital signature.");
            System.err.println("usage: java algo pubKeyFile dataFile signFile");
            System.exit(1);
        }
        int index = 0;
        String cfr_ignored_0 = args[index];
        String keyFile = args[++index];
        String dataFile = args[++index];
        String signFile = args[++index];
        ++index;
        Path path = Paths.get(keyFile, new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        X509EncodedKeySpec ks = new X509EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey pub = kf.generatePublic(ks);
        Signature sign = Signature.getInstance("SHA256withRSA");
        sign.initVerify(pub);
        try (FileInputStream in = null;){
            int len;
            in = new FileInputStream(dataFile);
            byte[] buf = new byte[2048];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                sign.update(buf, 0, len);
            }
        }
        path = Paths.get(signFile, new String[0]);
        bytes = Files.readAllBytes(path);
        System.out.println(String.valueOf(dataFile) + ": Signature " + (sign.verify(bytes) ? "OK" : "Not OK"));
    }
}

