/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.util.Validate;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;

public class JreKeyGenBin {
    public static void createKeys(String algo, int keySize, String outFile) throws Exception {
        Validate.isNotEmpty((String)algo);
        Validate.isPositive((int)keySize);
        Validate.isNotEmpty((String)outFile);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algo);
        kpg.initialize(keySize);
        KeyPair kp = kpg.generateKeyPair();
        try (FileOutputStream out = null;){
            out = new FileOutputStream(outFile);
            JreKeyGenBin.writeBinary(out, kp.getPrivate());
            ((OutputStream)out).close();
            out = new FileOutputStream(String.valueOf(outFile) + ".pub");
            JreKeyGenBin.writeBinary(out, kp.getPublic());
        }
    }

    private static void writeBinary(OutputStream out, Key key) throws IOException {
        out.write(key.getEncoded());
    }
}

