/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.ssl.CertificateUtils;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainNameValidator {
    private static final Logger logger = LoggerFactory.getLogger(DomainNameValidator.class);
    private static Pattern QUICK_IP_PATTERN;
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    static {
        try {
            QUICK_IP_PATTERN = Pattern.compile("^[a-f0-9\\.:]+$");
        }
        catch (PatternSyntaxException patternSyntaxException) {}
    }

    public static boolean match(X509Certificate certificate, String domainName) {
        Validate.isNotNull((Object)certificate, (String)"X509-certificate must be set");
        Validate.isNotEmpty((String)domainName, (String)"domain name must be set");
        domainName = domainName.toLowerCase();
        String matchDns = null;
        matchDns = !DomainNameValidator.isIpAddress(domainName) ? DomainNameValidator.matchDns(certificate, domainName) : DomainNameValidator.matchIpAddress(certificate, domainName);
        return matchDns != null;
    }

    public static String findDnsMatch(X509Certificate certificate, String domainName) {
        Validate.isNotNull((Object)certificate, (String)"X509-certificate must be set");
        Validate.isNotEmpty((String)domainName, (String)"domain name must be set");
        domainName = domainName.toLowerCase();
        String matchDns = null;
        matchDns = !DomainNameValidator.isIpAddress(domainName) ? DomainNameValidator.matchDns(certificate, domainName) : DomainNameValidator.matchIpAddress(certificate, domainName);
        return matchDns;
    }

    private static String matchIpAddress(X509Certificate certificate, String thisDomain) {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> altNameEntry : subjectAltNames) {
                    String altName;
                    Integer altNameType;
                    if (altNameEntry == null || 2 > altNameEntry.size() || (altNameType = (Integer)altNameEntry.get(0)) == null || altNameType != 7 || (altName = (String)altNameEntry.get(1)) == null || !thisDomain.equalsIgnoreCase(altName)) continue;
                    return altName;
                }
            }
        }
        catch (CertificateParsingException e) {
            logger.error("failed to parse certificate, reason = " + StringUtils.extractMessage((Exception)e));
        }
        return null;
    }

    private static String matchDns(X509Certificate certificate, String thisDomain) {
        String cn;
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> altNameEntry : subjectAltNames) {
                    String altName;
                    Integer altNameType;
                    if (altNameEntry == null || 2 > altNameEntry.size() || (altNameType = (Integer)altNameEntry.get(0)) == null || altNameType != 2 || (altName = (String)altNameEntry.get(1)) == null || !DomainNameValidator.matchDns(thisDomain, altName)) continue;
                    return altName;
                }
            }
        }
        catch (CertificateParsingException e) {
            logger.warn("failed to parse certificate, reason = " + StringUtils.extractMessage((Exception)e));
        }
        if ((cn = CertificateUtils.getFirstCommonNameFromSubject(certificate)) != null && DomainNameValidator.matchDns(thisDomain, cn)) {
            return cn;
        }
        return null;
    }

    public static boolean matchDns(String siteDomain, String certDomain) {
        if (siteDomain == null || siteDomain.length() == 0 || certDomain == null || certDomain.length() == 0) {
            return false;
        }
        boolean rval = siteDomain.equals(certDomain = certDomain.toLowerCase());
        if (!rval) {
            String[] thatDomainTokens;
            int thatDomainTokensNum;
            String[] thisDomainTokens = siteDomain.split("\\.");
            int thisDomainTokensNum = thisDomainTokens.length;
            if (thisDomainTokensNum >= (thatDomainTokensNum = (thatDomainTokens = certDomain.split("\\.")).length)) {
                int i = thatDomainTokensNum - 1;
                while (i >= 0) {
                    rval = thisDomainTokens[i].equals(thatDomainTokens[i]);
                    if (!rval) {
                        boolean bl = rval = i == 0 && thisDomainTokensNum == thatDomainTokensNum;
                        if (rval && !(rval = thatDomainTokens[0].equals("*"))) {
                            rval = DomainNameValidator.domainTokenMatch(thisDomainTokens[0], thatDomainTokens[0]);
                        }
                        break;
                    }
                    --i;
                }
            } else {
                rval = certDomain.equals("*." + siteDomain);
            }
        }
        logger.info(String.format("matchDns(%s): site domain: %s cert domain: %s", rval, siteDomain, certDomain));
        return rval;
    }

    private static boolean domainTokenMatch(String thisDomainToken, String thatDomainToken) {
        int starIndex;
        if (thisDomainToken != null && thatDomainToken != null && (starIndex = thatDomainToken.indexOf(42)) >= 0 && thatDomainToken.length() - 1 <= thisDomainToken.length()) {
            String prefix = thatDomainToken.substring(0, starIndex);
            String suffix = thatDomainToken.substring(starIndex + 1);
            return thisDomainToken.startsWith(prefix) && thisDomainToken.endsWith(suffix);
        }
        return false;
    }

    private static boolean isIpAddress(String domain) {
        boolean rval = false;
        if (!StringUtils.isEmpty((String)domain)) {
            try {
                rval = QUICK_IP_PATTERN.matcher(domain).matches();
                if (rval) {
                    rval = domain.equals(InetAddress.getByName(domain).getHostAddress());
                }
            }
            catch (UnknownHostException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "unknown host";
                }
                logger.error(String.format("isIpAddress(%s): %s", domain, errorMessage));
                rval = false;
            }
        }
        return rval;
    }
}

