/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.ssl.CertificateInfo;
import com.remainsoftware.common.ssl.CertificateUtils;
import com.remainsoftware.common.ssl.CustomTrustManagerUtils;
import com.remainsoftware.common.util.FileUtils;
import com.remainsoftware.common.util.IcingException;
import com.remainsoftware.common.util.NetUtils;
import com.remainsoftware.common.util.StringIcing;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertPathBuilderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomX509TrustManager
implements X509TrustManager {
    private static final Logger logger = LoggerFactory.getLogger(CustomX509TrustManager.class);
    private X509TrustManager defaultJSSEX509TrustManager;
    private Object trustManagersSync = new Object();
    private List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();
    private static final String NEWLINE_CHARACTER = "\n";
    private static final String CERT_BEGIN = "-----BEGIN CERTIFICATE-----\n";
    private static final String END_CERT = "-----END CERTIFICATE-----\n";
    private static final String PRIVATE_KEY_BEGIN = "-----BEGIN PRIVATE KEY-----\n";
    private static final String PRIVATE_KEY_END = "-----END PRIVATE KEY-----\n";
    private static final String PFX_FILE_PATH = "c:/temp/certificates/plato.remain.local.pfx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomX509TrustManager() throws Exception {
        TrustManagerFactory trustMgrFactory = CertificateUtils.createX509TrustmanagerFactory(null);
        TrustManager[] trustManagerArray = trustMgrFactory.getTrustManagers();
        int n = trustManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager trustManager = trustManagerArray[n2];
            if (trustManager instanceof X509TrustManager) {
                this.defaultJSSEX509TrustManager = (X509TrustManager)trustManager;
                Object object = this.trustManagersSync;
                synchronized (object) {
                    this.trustManagers.add(this.defaultJSSEX509TrustManager);
                    break;
                }
            }
            ++n2;
        }
        if (this.defaultJSSEX509TrustManager == null) {
            String msg = "Failed to initialize CustomX509TrustManager, default X509 trust manager was not found";
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        logger.info("default X509 trust manager initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addX509TrustManager(File trustStoreFile) {
        block7: {
            Validate.isNotNull((Object)trustStoreFile);
            X509TrustManager additionalX509TrustManager = null;
            if (!trustStoreFile.exists() || !trustStoreFile.canRead()) {
                logger.error(String.format("cannot find or read trust store at location: '%s'", trustStoreFile.getAbsolutePath()));
                return false;
            }
            String trustStoreFileName = trustStoreFile.getAbsolutePath();
            String trustStoreFileExt = StringUtils.getFileExtension((String)trustStoreFile.getAbsolutePath());
            boolean isJKSTrustStore = trustStoreFileExt.equalsIgnoreCase("jks");
            try {
                additionalX509TrustManager = CustomX509TrustManager.createTrustManager(trustStoreFileName, String.valueOf(trustStoreFileName) + ".pwd", isJKSTrustStore ? "JKS" : "PKCS12");
                if (additionalX509TrustManager == null) {
                    logger.error(String.format("additional trust manager was not setup from location: %s (createTrustManager returned null)", trustStoreFileName));
                    break block7;
                }
                Object object = this.trustManagersSync;
                synchronized (object) {
                    this.trustManagers.add(additionalX509TrustManager);
                    logger.info(String.format("additional trust manager setup from location: %s", trustStoreFileName));
                }
                return true;
            }
            catch (Exception e) {
                logger.error(String.format("failed to create additional trust manager from trust-store: %s, reason = %s", trustStoreFileName, StringUtils.extractMessage((Exception)e)));
            }
        }
        return false;
    }

    public boolean addX509TrustManager(String trustStoreFileName) {
        Validate.isNotEmpty((String)trustStoreFileName);
        return this.addX509TrustManager(new File(trustStoreFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Exception certExc = null;
        Object object = this.trustManagersSync;
        synchronized (object) {
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkClientTrusted(chain, authType);
                    return;
                }
                catch (Exception e) {
                    if (!(e instanceof CertificateException) && !(e instanceof CertPathBuilderException) || certExc != null) continue;
                    certExc = e;
                }
            }
        }
        if (certExc != null) {
            if (certExc instanceof CertificateException) {
                throw (CertificateException)certExc;
            }
            throw new CertificateException(certExc);
        }
        throw new CertificateException("client certificate chain is not trusted by any trust manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Exception certExc = null;
        Object object = this.trustManagersSync;
        synchronized (object) {
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return;
                }
                catch (Exception e) {
                    if (e instanceof CertificateException || e instanceof CertPathBuilderException) {
                        if (certExc != null) continue;
                        certExc = e;
                        continue;
                    }
                    throw new CertificateException(e);
                }
            }
        }
        CustomX509TrustManager.processServerTrustedException(chain, certExc);
    }

    /*
     * Exception decompiling
     */
    public static X509TrustManager createTrustManager(String trustStoreFileName, String keyStoreType) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static X509TrustManager createTrustManager(String trustStoreFileName, String trustStorePasswordFileName, String keyStoreType) throws Exception {
        TrustManager[] trustManagers;
        File trustStorePasswordFile;
        Validate.isNotEmpty((String)"trust-store file name must be set", (String)trustStoreFileName);
        if (StringUtils.isEmpty((String)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        File file = trustStorePasswordFile = !StringUtils.isEmpty((String)trustStorePasswordFileName) ? new File(trustStorePasswordFileName) : null;
        if (trustStorePasswordFile == null || !trustStorePasswordFile.exists()) {
            return CustomX509TrustManager.createTrustManager(trustStoreFileName, keyStoreType);
        }
        String trustStorePassword = CustomX509TrustManager.getPassword(trustStorePasswordFileName);
        if (StringUtils.isEmpty((String)trustStorePassword)) {
            logger.error(String.format("failed to get password for trust store file: %s", trustStoreFileName));
            return null;
        }
        KeyStore trustStore = CustomX509TrustManager.getStore(trustStoreFileName, trustStorePassword, keyStoreType, null);
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        TrustManager[] trustManagerArray = trustManagers = trustFactory.getTrustManagers();
        int n = trustManagers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager trustManager = trustManagerArray[n2];
            if (trustManager instanceof X509TrustManager) {
                return (X509TrustManager)trustManager;
            }
            ++n2;
        }
        return null;
    }

    private static String getPassword(String trustStorePasswordFilename) {
        File passwordFile = new File(trustStorePasswordFilename);
        String baseFileName = passwordFile.getName();
        if (passwordFile.exists() && passwordFile.canRead()) {
            String password;
            block9: {
                password = FileUtils.readFile((File)passwordFile).trim();
                if (!StringIcing.isIcedPropertyString((String)password)) {
                    try {
                        String encrypted = StringIcing.iceToPropertyString((String)password, (String)StringUtils.reverse((String)baseFileName));
                        FileUtils.writeFile((File)passwordFile, (String)encrypted, (boolean)false);
                    }
                    catch (Exception e) {
                        logger.error(String.format("failed to encrypt content of trust store password file: %s, reason = %s", trustStorePasswordFilename, e.getMessage()));
                    }
                    break block9;
                }
                try {
                    password = StringIcing.diceFromPropertyString((String)password, (String)StringUtils.reverse((String)baseFileName));
                }
                catch (IcingException e) {
                    logger.error(String.format("failed to decrypt content of trust-store password file: %s, reason = %s", trustStorePasswordFilename, e.getMessage()));
                    return null;
                }
            }
            try {
                return password;
            }
            catch (IOException e) {
                logger.error("failed to read trust-store password file: " + trustStorePasswordFilename, (Throwable)e);
            }
        }
        return null;
    }

    public static void processServerTrustedException(X509Certificate[] x509Certs, Exception jsseException) throws CertificateException {
        Validate.isNotNull((Object)x509Certs, (String)"X509Certificate[] must be set");
        Validate.isTrue((x509Certs.length > 0 ? 1 : 0) != 0, (String)"X509Certificate[] length must be > 0");
        try {
            String hostName;
            CharSequence[] hostNames;
            X509Certificate x509Cert = x509Certs[0];
            CertificateUtils.setLastProcessedCertificate(x509Cert);
            CharSequence[] charSequenceArray = hostNames = CertificateUtils.getCertificateHostNames(x509Cert);
            int n = hostNames.length;
            int n2 = 0;
            while (n2 < n) {
                hostName = charSequenceArray[n2];
                if (CertificateUtils.isSessionTrustedHost(hostName)) {
                    return;
                }
                ++n2;
            }
            charSequenceArray = hostNames;
            n = hostNames.length;
            n2 = 0;
            while (n2 < n) {
                hostName = charSequenceArray[n2];
                if (CertificateUtils.isTrustedHost(hostName)) {
                    CustomTrustManagerUtils.processTrustedHostCertificite(x509Cert, hostName);
                    return;
                }
                ++n2;
            }
            charSequenceArray = hostNames;
            n = hostNames.length;
            n2 = 0;
            while (n2 < n) {
                hostName = charSequenceArray[n2];
                if (NetUtils.isLocalAddress((String)hostName) && (CertificateUtils.isTrustedHost("localhost") || CertificateUtils.isTrustedHost("127.0.0.1") || CertificateUtils.isTrustedHost("::1"))) {
                    CustomTrustManagerUtils.isValidCertificate(hostName, x509Cert, null, null);
                    X509Certificate trustedCert = CertificateUtils.getTrustedHostCertificate(hostName);
                    if (trustedCert != null) {
                        CustomTrustManagerUtils.isValidCertificate(hostName, x509Cert, CertificateUtils.getCertificateIssuerDN(trustedCert), trustedCert.getPublicKey());
                    } else {
                        CertificateUtils.addCertificateTrustedHost(hostName, x509Cert);
                        CustomTrustManagerUtils.saveCertificate(hostName, x509Cert, true);
                    }
                    return;
                }
                ++n2;
            }
            CertificateInfo certInfo = new CertificateInfo(x509Cert);
            String san = certInfo.getSubjectAltName();
            String msg = MessageFormat.format("{0} (self-signed={1}, chain-length={2}) for host-names (CN+SAN): [{3}], issuer: [{4}], subject-alternative-names: [{5}], reason = host not listed as trusted", "Certificate error; host SSL certificate rejected", CertificateUtils.isSelfSigned(x509Cert), x509Certs.length, String.join((CharSequence)", ", hostNames), CertificateUtils.getCertificateIssuerDN(x509Cert), san);
            logger.info(msg);
            if (logger.isDebugEnabled() || logger.isTraceEnabled()) {
                logger.debug(String.format("Certificate dump: %s", x509Cert.toString()));
            }
            throw new CertificateException(msg);
        }
        catch (Exception e) {
            if (jsseException != null) {
                logger.warn(String.format("certificate rejected by default SSL trust manager, reason = %s", StringUtils.extractMessage((Exception)jsseException)));
            }
            if (e instanceof CertificateException) {
                if (e.getMessage() != null && !e.getMessage().startsWith("Certificate error;")) {
                    throw new CertificateException("Certificate error; " + StringUtils.extractMessage((Exception)e), e);
                }
                throw (CertificateException)e;
            }
            String msg = String.format("%s: %s, reason = %s", "Certificate error; failed processing host SSL certificate", x509Certs[0].toString(), StringUtils.extractMessage((Exception)e));
            logger.error(msg, (Throwable)e);
            throw new CertificateException(msg, e);
        }
    }

    public static KeyStore getStore(String storeFilename, String storePassword, String storeType, String storeProvider) throws IOException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException {
        KeyStore ks = null;
        InputStream in = null;
        try {
            ks = storeProvider == null ? KeyStore.getInstance(storeType) : KeyStore.getInstance(storeType, storeProvider);
            in = new FileInputStream(storeFilename);
            char[] storePass = null;
            if (storePassword != null && !"".equals(storePassword)) {
                storePass = storePassword.toCharArray();
            }
            ks.load(in, storePass);
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("Cannot close store file: " + storeFilename, (Throwable)e);
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultJSSEX509TrustManager.getAcceptedIssuers();
    }

    public static void main2(String[] args) throws Exception {
        String inputLine;
        URL secure = new URL("https://helpdesk.remainsoftware.com");
        HttpURLConnection httpConn = NetUtils.openHttpConnection((URL)secure);
        BufferedReader in = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            System.out.println(inputLine);
        }
        in.close();
    }

    public static void main(String[] args) throws Exception {
        String PFX_PASSWORD = "kre???n";
        try {
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(new FileInputStream(PFX_FILE_PATH), PFX_PASSWORD.toCharArray());
            Enumeration<String> es = ks.aliases();
            String alias = "";
            boolean isAliasWithPrivateKey = false;
            while (es.hasMoreElements()) {
                alias = es.nextElement();
                isAliasWithPrivateKey = ks.isKeyEntry(alias);
                if (isAliasWithPrivateKey) break;
            }
            if (!isAliasWithPrivateKey) {
                return;
            }
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(PFX_PASSWORD.toCharArray()));
            Certificate publicKeyCertificate = pkEntry.getCertificate();
            String publicCertificatePem = CustomX509TrustManager.formatCert(new String(Base64.getEncoder().encode(publicKeyCertificate.getEncoded())));
            String leafPublicCertificatePem = CERT_BEGIN + publicCertificatePem + END_CERT;
            System.out.println(leafPublicCertificatePem);
            PrivateKey privateKey = pkEntry.getPrivateKey();
            String privatePem = CustomX509TrustManager.formatCert(new String(Base64.getEncoder().encode(privateKey.getEncoded())));
            String leafPrivateKey = PRIVATE_KEY_BEGIN + privatePem + PRIVATE_KEY_END;
            System.out.println(leafPrivateKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String formatCert(String base64EncodedCert) {
        ArrayList<String> certLines = new ArrayList<String>();
        while (base64EncodedCert.length() > 64) {
            certLines.add(base64EncodedCert.substring(0, 64));
            base64EncodedCert = base64EncodedCert.substring(64);
        }
        certLines.add(base64EncodedCert);
        int i = 0;
        while (i < certLines.size()) {
            certLines.set(i, ((String)certLines.get(i)).concat(NEWLINE_CHARACTER));
            ++i;
        }
        String pemBody = "";
        for (String certLine : certLines) {
            pemBody = String.valueOf(pemBody) + certLine;
        }
        return pemBody;
    }
}

