/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.handler;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.list.SpooledFileListItem;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.validator.ObjectPathValidator;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.spools.SpoolUtil;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class CopySpoolHandler {
    private String dialogTitle;
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IActiveConnectionService connectionService;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IConnectionUtilities connUtilFacade;

    public CopySpoolHandler() {
        this.dialogTitle = Messages.spools_handler_copy_dialog_title;
    }

    @Execute
    public void run(@Named(value="activeShell") Shell shell) {
        Object selection = this.selectionService.getSelection("miworkplace.spools.part");
        if (selection != null) {
            IConnection activeConnection = this.connectionService.getLastUsedActiveConnection();
            if (activeConnection == null) {
                Notifier.notify((String)this.dialogTitle, (String)Messages.spools_handler_copy_conn_not_active, (Notifier.Type)Notifier.Type.DISCONNECTED, (boolean)true);
                return;
            }
            AS400 system = activeConnection.getSystem();
            InputDialog dialog = new InputDialog(shell, Messages.spools_handler_copy_input_title, Messages.spools_handler_copy_input_prompt, null, (IInputValidator)ContextInjectionFactory.make(ObjectPathValidator.class, (IEclipseContext)this.context));
            if (dialog.open() == 0) {
                String[] qparts = dialog.getValue().toUpperCase().split("/");
                if (qparts.length == 2) {
                    QSYSObjectPathName qname = new QSYSObjectPathName(qparts[0], qparts[1], "OUTQ");
                    OutputQueue queue = new OutputQueue(system, qname.getPath());
                    if (this.connUtilFacade.doesObjectExist(activeConnection, qname.getPath())) {
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        for (SpooledFileListItem spoolItem : ss) {
                            SpooledFile spool = SpoolUtil.toSpoolFile(this.connectionService.getLastUsedActiveConnection().getSystem(), spoolItem);
                            try {
                                spool.copy(queue);
                            }
                            catch (Exception e) {
                                String message = "Could not copy spooled file " + spoolItem.getName() + ". Error: " + e.getMessage();
                                this.logger.error(message, (Throwable)e);
                                Notifier.error((String)this.dialogTitle, (String)String.format(Messages.spools_handler_copy_error, spoolItem.getName()));
                            }
                        }
                        this.eventBroker.send("miworkplace/spools/update", new Object());
                    } else {
                        Notifier.error((String)this.dialogTitle, (String)String.format(Messages.spools_handler_copy_no_outqueue, dialog.getValue()));
                    }
                } else {
                    this.logger.debug((Option)miworkplace.spools.debug.Option.spools, "The user entered an invalid qualified output queue: " + dialog.getValue());
                    Notifier.error((String)this.dialogTitle, (String)String.format(Messages.spools_handler_copy_invalid_path, dialog.getValue()));
                }
            }
        }
    }
}

