/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.editor;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.TextAttribute;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.services.api.ITextAttributeService;
import miworkplace.spools.editor.IDocumentReceiver;
import miworkplace.spools.editor.SpooledFileContentLoader;
import miworkplace.ui.api.IFindReplaceSupport;
import miworkplace.ui.api.IPrintable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.json.JSONArray;
import org.json.JSONException;

public class SpooledFileEditor
implements IDocumentReceiver,
IPrintable,
IAdaptable,
IFindReplaceSupport {
    private Debug logger = Debug.getInstance();
    @Inject
    private IConnectionUtilities connUtils;
    @Inject
    private UISynchronize sync;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private Display display;
    @Inject
    private ITextAttributeService textAttributeService;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IStylingEngine stylingEngine;
    private TextViewer viewer;
    private String inputUri;
    private String connectionName;

    @Inject
    public SpooledFileEditor(MPart part) {
        this.inputUri = (String)part.getPersistedState().get("miworkplace.editor.inputUri");
        this.connectionName = (String)part.getPersistedState().get("miworkplace.editor.connection");
    }

    @PostConstruct
    public void createControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        int styles = 66306;
        this.viewer = new TextViewer(parent, styles);
        this.viewer.getTextWidget().setFont(this.buildFont(this.viewer.getTextWidget().getFont()));
        this.stylingEngine.setClassname((Object)this.viewer.getTextWidget(), "miworkplace-editor-text");
        this.buildEditorInput(this.inputUri, this.connectionName);
    }

    private Font buildFont(Font defaultFont) {
        TextAttribute ta = this.textAttributeService.get("miworkplace.ui.pref.text.basic.editor.font");
        try {
            String s;
            if (ta != null && (s = ta.getValue()) != null) {
                JSONArray array = new JSONArray(s);
                FontData[] fontList = new FontData[array.length()];
                int i = 0;
                while (i < array.length()) {
                    fontList[i] = new FontData(array.getString(i));
                    ++i;
                }
                Font f = new Font((Device)this.display, fontList);
                return f;
            }
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return defaultFont;
    }

    private void buildEditorInput(String inputUri, String connectionName) {
        IConnection connection = this.connectionManager.get(connectionName);
        SpooledFileContentLoader loader = new SpooledFileContentLoader(this, connection, inputUri, this.sync, this.applicationPreferences.get("miworkplace.spools.wscst", null), this.connUtils);
        BusyIndicator.showWhile((Display)this.display, (Runnable)loader);
    }

    @Override
    public void receiveDocument(IDocument document) {
        this.viewer.setDocument(document);
        this.viewer.setEditable(false);
    }

    public String getTitle() {
        try {
            URI uri = new URI(this.inputUri);
            String[] parts = Arrays.copyOfRange(uri.getPath().split("/"), 1, 6);
            return parts[0] + " (" + parts[2] + "/" + parts[3] + "/" + parts[4] + ")";
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getContent() {
        return this.viewer.getDocument().get();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ITextOperationTarget.class) {
            return this.viewer;
        }
        if (adapter == ITextOperationTargetExtension.class) {
            return this.viewer;
        }
        return null;
    }

    public IDocument getDocument() {
        return this.viewer.getDocument();
    }

    public ITextViewer getViewer() {
        return this.viewer;
    }
}

