/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.list.SpooledFileListItem;
import com.ibm.as400.access.list.SpooledFileOpenList;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.spools.SpooledFileComparator;
import miworkplace.spools.debug.Option;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;

public class SpooledFilesPart {
    public static final String ID = "miworkplace.spools.part";
    private static final String PREF_USER_FILTER = "user.filter";
    private static final String PREF_SORT_CRITERIA = "sortCriteria";
    private static final String PREF_SORT_DIRECTION = "sortDirection";
    private static final String POPUPMENU_ID = "miworkplace.spools.popupmenu";
    private String dialogTitle;
    @Inject
    private UISynchronize sync;
    @Inject
    private Display display;
    private Debug logger = Debug.getInstance();
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IActiveConnectionService activeConnService;
    @Inject
    private IEclipseContext fContext;
    @Inject
    private EHelpService fHelpService;
    private MPart part;
    private Composite parentComposite;
    private StackLayout mainLayout;
    private Composite noConnectionLabel;
    private TableViewer viewer;
    private SpooledFileComparator sorter;
    private HashMap<String, List<SpooledFileListItem>> spoolLists = new HashMap();
    private String currentConnectionName = null;
    private Job job;
    private Collection<SpooledFileListItem> viewerInput = new ArrayList<SpooledFileListItem>();
    private QSYSObjectPathName qsysname = new QSYSObjectPathName();
    private SimpleDateFormat datfmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean fUserFilter;

    @Inject
    public SpooledFilesPart(MPart part) {
        this.part = part;
        this.sorter = new SpooledFileComparator(this.logger);
        this.dialogTitle = Messages.spools_dialog_title;
        Map persistedState = part.getPersistedState();
        if (persistedState.containsKey(PREF_SORT_CRITERIA)) {
            this.sorter.setCriteria(Integer.parseInt((String)persistedState.get(PREF_SORT_CRITERIA)));
        }
        if (persistedState.containsKey(PREF_SORT_DIRECTION)) {
            this.sorter.setSortDirection(Boolean.parseBoolean((String)persistedState.get(PREF_SORT_DIRECTION)));
        }
        this.fUserFilter = persistedState.getOrDefault(PREF_USER_FILTER, "true").equals("true");
    }

    @PostConstruct
    public void postConstruct(MPart part, Composite parent, EMenuService menuService, ESelectionService selectionService) {
        this.part = part;
        this.parentComposite = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.noConnectionLabel = this.buildNoConnectionLabel(parent);
        this.buildTableViewer(parent, selectionService);
        menuService.registerContextMenu((Object)this.viewer.getControl(), POPUPMENU_ID);
        IConnection connection = this.activeConnService.getLastUsedActiveConnection();
        if (connection == null || !connection.isConnected()) {
            this.showNoActiveConnection();
        } else {
            this.currentConnectionName = connection.getName();
            this.showSpooledFiles();
        }
        this.fHelpService.setHelp((Object)parent, "miworkplace.help.MIW: Spooled Files");
    }

    private Composite buildNoConnectionLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.spools_part_no_active_conn);
        return form;
    }

    private void buildTableViewer(Composite parent, final ESelectionService selectionService) {
        this.viewer = new TableViewer(parent, 66306);
        this.composeTable();
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput(this.viewerInput);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WorkspaceUtil.runCommand((String)"miworkplace.spools.command.open", (IEclipseContext)SpooledFilesPart.this.fContext);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
            }
        });
    }

    public boolean isJobSpooledFilesShowing() {
        return this.job != null;
    }

    @Inject
    @Optional
    private void getNotifiedShowJobSpooledFiles(@UIEventTopic(value="miworkplace/spools/job") Event event) {
        this.job = new Job(this.connectionManager.get(event.getProperty("connection").toString()).getSystem(), event.getProperty("jobname").toString(), event.getProperty("username").toString(), event.getProperty("jobnumber").toString());
        this.fUserFilter = false;
        this.showSpooledFiles();
        this.part.setTooltip("Show spooled files of job " + this.job.toString());
    }

    @Inject
    @Optional
    private void getNotifiedShowUserSpooledFiles(@UIEventTopic(value="miworkplace/spools/user") String connectionName) {
        if (this.job != null) {
            this.fUserFilter = false;
        }
        this.job = null;
        this.currentConnectionName = connectionName;
        this.fUserFilter = !this.fUserFilter;
        this.spoolLists.remove(connectionName);
        this.showSpooledFiles();
        if (this.fUserFilter) {
            this.part.setTooltip("Show your personal spooled files for connection " + this.currentConnectionName);
        } else {
            this.part.setTooltip("Show all spooled files of the last 7 days for connection " + this.currentConnectionName);
        }
    }

    @Inject
    @Optional
    private void getNotifiedForRefresh(@UIEventTopic(value="miworkplace/spools/refresh") String connectionName) {
        this.spoolLists.remove(connectionName);
        this.currentConnectionName = connectionName;
        this.showSpooledFiles();
    }

    @Inject
    @Optional
    private void getNotified(@UIEventTopic(value="miworkplace/services/last_used_connection") IConnection connection) {
        if (connection == null || !connection.isConnected()) {
            this.showNoActiveConnection();
        } else {
            this.currentConnectionName = connection.getName();
            this.showSpooledFiles();
        }
    }

    @Inject
    @Optional
    private void getNotifiedForUpdate(@UIEventTopic(value="miworkplace/spools/update") Object dummy) {
        this.spoolLists.remove(this.currentConnectionName);
        this.showSpooledFiles();
    }

    @Inject
    @Optional
    private void getNotifiedOnConnecting(@UIEventTopic(value="miworkplace/connection/connected") IConnection connection) {
        this.spoolLists.remove(connection.getName());
        this.showSpooledFiles();
    }

    @Inject
    @Optional
    private void getNotifiedOnDisconnecting(@UIEventTopic(value="miworkplace/connection/disconnected") IConnection connection) {
        this.spoolLists.remove(connection.getName());
        if (connection.getName().equals(this.currentConnectionName)) {
            this.currentConnectionName = null;
        }
        this.showSpooledFiles();
    }

    private List<SpooledFileListItem> loadSpooledFiles(IConnection connection, Job job) throws Exception {
        SpooledFileOpenList list = new SpooledFileOpenList(connection.getSystem());
        if (job == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -7);
            Date start = cal.getTime();
            this.logger.debug((miworkplace.common.debug.Option)Option.spools, "SpooledFilesPart: Start date set to " + start.toString());
            list.setFilterCreationDate(start, null);
            if (this.fUserFilter) {
                list.setFilterUsers(new String[]{this.connectionManager.get(this.currentConnectionName).getUsername().toUpperCase()});
            }
        } else {
            list.setFilterJobInformation(job.getName(), job.getUser(), job.getNumber());
        }
        try {
            ArrayList<SpooledFileListItem> arrayList = Collections.list(list.getItems());
            return arrayList;
        }
        finally {
            list.close();
        }
    }

    private void showNoActiveConnection() {
        this.mainLayout.topControl = this.noConnectionLabel;
        if (!this.parentComposite.isDisposed()) {
            this.parentComposite.layout();
            this.viewerInput.clear();
            this.part.setTooltip(Messages.spools_part_no_active_conn);
        }
    }

    public void showSpooledFiles() {
        IConnection connection;
        this.mainLayout.topControl = this.viewer.getControl();
        this.parentComposite.layout();
        if (this.currentConnectionName == null && (connection = this.activeConnService.getLastUsedActiveConnection()) != null && connection.isConnected()) {
            this.currentConnectionName = connection.getName();
        }
        if (this.currentConnectionName == null) {
            this.showNoActiveConnection();
            return;
        }
        List<SpooledFileListItem> list = this.spoolLists.get(this.currentConnectionName);
        if (this.job == null && list != null) {
            this.viewerInput.clear();
            this.viewerInput.addAll(list);
            this.viewer.refresh();
        } else {
            BusyIndicator.showWhile((Display)this.display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        List<SpooledFileListItem> spooledFileList = SpooledFilesPart.this.loadSpooledFiles(SpooledFilesPart.this.connectionManager.get(SpooledFilesPart.this.currentConnectionName), SpooledFilesPart.this.job);
                        if (SpooledFilesPart.this.job == null) {
                            SpooledFilesPart.this.spoolLists.put(SpooledFilesPart.this.currentConnectionName, spooledFileList);
                        }
                        SpooledFilesPart.this.viewerInput.clear();
                        SpooledFilesPart.this.viewerInput.addAll(spooledFileList);
                        SpooledFilesPart.this.viewer.refresh();
                    }
                    catch (Exception e) {
                        SpooledFilesPart.this.logger.error("Could not get spooled files for connection " + SpooledFilesPart.this.currentConnectionName + ".", (Throwable)e);
                        SpooledFilesPart.this.sync.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Notifier.error((String)(this).SpooledFilesPart.this.dialogTitle, (String)String.format(Messages.spools_part_load_error, (this).SpooledFilesPart.this.activeConnService.getLastUsedActiveConnection().getName()));
                            }
                        });
                    }
                }
            });
        }
        if (this.job == null) {
            this.part.setTooltip(String.format(Messages.spools_ttt_user, this.currentConnectionName));
        } else {
            this.part.setTooltip(String.format(Messages.spools_ttt_job, this.job.toString(), this.currentConnectionName));
        }
    }

    private void composeTable() {
        Table table = this.viewer.getTable();
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText(Messages.spools_col1);
        col1.setWidth(100);
        col1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 1));
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setText(Messages.spools_col2);
        col2.setWidth(100);
        col2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 2));
        TableColumn col3 = new TableColumn(table, 16384);
        col3.setText(Messages.spools_col3);
        col3.setWidth(100);
        col3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 3));
        TableColumn col4 = new TableColumn(table, 16384);
        col4.setText(Messages.spools_col4);
        col4.setWidth(100);
        col4.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 4));
        TableColumn col6 = new TableColumn(table, 16384);
        col6.setText(Messages.spools_col5);
        col6.setWidth(60);
        col6.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 5));
        TableColumn col7 = new TableColumn(table, 16384);
        col7.setText(Messages.spools_col6);
        col7.setWidth(100);
        col7.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 6));
        TableColumn col8 = new TableColumn(table, 16384);
        col8.setText(Messages.spools_col7);
        col8.setWidth(80);
        col8.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 7));
        TableColumn col9 = new TableColumn(table, 16384);
        col9.setText(Messages.spools_col8);
        col9.setWidth(60);
        col9.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 8));
        TableColumn col10 = new TableColumn(table, 16384);
        col10.setText(Messages.spools_col9);
        col10.setWidth(150);
        col10.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.viewer, 9));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setComparator((ViewerComparator)this.sorter);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public SpooledFileComparator getViewerSorter() {
        try {
            return (SpooledFileComparator)this.viewer.getComparator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SpooledFileListItem[] getSpooledFiles() {
        return this.viewerInput.toArray(new SpooledFileListItem[this.viewerInput.size()]);
    }

    public boolean isUserFilter() {
        return this.fUserFilter;
    }

    public void removeSpoolFromView(SpooledFileListItem spool) {
        this.viewerInput.remove(spool);
        this.updateViewer();
    }

    public void addSpoolToView(SpooledFileListItem spool) {
        this.viewerInput.add(spool);
        this.updateViewer();
    }

    public void updateViewer() {
        this.viewer.refresh();
    }

    @PersistState
    void persist(MPart part) {
        Map persistedState = part.getPersistedState();
        persistedState.put(PREF_SORT_CRITERIA, String.valueOf(this.sorter.getCriteria()));
        persistedState.put(PREF_SORT_DIRECTION, String.valueOf(this.sorter.isSortDescending()));
        persistedState.put(PREF_USER_FILTER, String.valueOf(this.fUserFilter));
    }

    class ColumnSelectionAdapter
    extends SelectionAdapter {
        private final TableViewer viewer;
        private final int sortCriteria;

        public ColumnSelectionAdapter(TableViewer viewer, int sortCriteria) {
            this.viewer = viewer;
            this.sortCriteria = sortCriteria;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.viewer.getComparator() instanceof SpooledFileComparator) {
                if (SpooledFilesPart.this.sorter.getCriteria() == this.sortCriteria) {
                    SpooledFilesPart.this.sorter.setCriteria(this.sortCriteria).setSortDirection(!SpooledFilesPart.this.sorter.isSortDescending());
                } else {
                    SpooledFilesPart.this.sorter.setCriteria(this.sortCriteria).setSortDirection(false);
                }
                this.viewer.refresh();
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Collection spools = (Collection)parent;
            Object[] prtObjects = spools.toArray(new SpooledFileListItem[spools.size()]);
            return prtObjects;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Object text = null;
            SpooledFileListItem prtObject = (SpooledFileListItem)obj;
            try {
                switch (index) {
                    case 0: {
                        text = prtObject.getName();
                        break;
                    }
                    case 1: {
                        text = prtObject.getJobUser();
                        break;
                    }
                    case 2: {
                        SpooledFilesPart.this.qsysname.setPath(prtObject.getOutputQueue());
                        text = SpooledFilesPart.this.qsysname.getObjectName();
                        break;
                    }
                    case 3: {
                        text = prtObject.getUserData();
                        break;
                    }
                    case 4: {
                        text = prtObject.getStatus();
                        break;
                    }
                    case 5: {
                        text = prtObject.getFormType();
                        break;
                    }
                    case 6: {
                        text = "" + prtObject.getNumber();
                        break;
                    }
                    case 7: {
                        text = "" + prtObject.getTotalPages();
                        break;
                    }
                    case 8: {
                        text = SpooledFilesPart.this.datfmt.format(prtObject.getCreationDate());
                        break;
                    }
                    default: {
                        text = "";
                        break;
                    }
                }
            }
            catch (Exception e) {
                SpooledFilesPart.this.logger.error("Could not get attribute " + index + " from spooled file " + String.valueOf(obj) + ".", (Throwable)e);
                text = "";
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

