/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.rest;

import jakarta.inject.Inject;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.rest.HttpRequest;
import miworkplace.ui.rest.RequestPersistence;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class RequestsMenuContribution {
    private final String SELECT_REQUEST_COMMAND_ID = "miworkplace.ui.rest.command.select.request";
    @Inject
    private RequestPersistence persistence;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, ESelectionService selectionService) {
        List<HttpRequest> requests = this.persistence.list();
        if (requests.isEmpty()) {
            MDirectMenuItem item = this.createNoRequestsItem();
            items.add((MMenuElement)item);
        } else {
            MCommand command = this.getCommandInstance("miworkplace.ui.rest.command.select.request");
            for (HttpRequest request : requests) {
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                dynamicItem.setLabel(request.getMethod() + " " + request.getEndpoint());
                dynamicItem.setCommand(command);
                dynamicItem.getTransientData().put("request", request);
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private MDirectMenuItem createNoRequestsItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.rest_norequest);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }

    private MCommand getCommandInstance(String commandId) {
        List commands = this.application.getCommands();
        for (MCommand command : commands) {
            if (!command.getElementId().equals(commandId)) continue;
            return command;
        }
        return null;
    }
}

