/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.markdown;

import jakarta.inject.Inject;
import miworkplace.ui.api.IOutlinePageProvider;
import miworkplace.ui.editor.ifs.StreamFileEditor;
import miworkplace.ui.editor.markdown.MarkdownOutlinePage;
import miworkplace.ui.editor.markdown.MarkdownSourceViewerConfiguration;
import miworkplace.ui.editor.markdown.text.MarkdownPartitionScanner;
import miworkplace.ui.editor.markdown.text.MarkdownPartitionTypes;
import miworkplace.ui.editor.markdown.text.SourceModelReconcileStrategy;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MarkdownStreamFileEditor
extends StreamFileEditor
implements IOutlinePageProvider {
    private MarkdownOutlinePage outlinePage;

    @Inject
    public MarkdownStreamFileEditor(MPart part, IResourcePool imagePool) {
        super(part, imagePool);
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        IEclipseContext additionalContext = EclipseContextFactory.create((String)this.memberPath);
        additionalContext.set("memberPath", (Object)this.memberPath);
        additionalContext.set("inputUri", (Object)this.inputUri);
        SourceModelReconcileStrategy strategy = (SourceModelReconcileStrategy)ContextInjectionFactory.make(SourceModelReconcileStrategy.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        IEclipseContext sourceViewerContext = this.context.createChild();
        sourceViewerContext.set(SourceModelReconcileStrategy.class, (Object)strategy);
        return (SourceViewerConfiguration)ContextInjectionFactory.make(MarkdownSourceViewerConfiguration.class, (IEclipseContext)sourceViewerContext);
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        MarkdownPartitionScanner scanner = new MarkdownPartitionScanner();
        return new FastPartitioner((IPartitionTokenScanner)scanner, MarkdownPartitionTypes.PARTITION_TYPES);
    }

    protected boolean supportFormatLines() {
        return false;
    }

    protected void registerContextMenu() {
        this.menuService.registerContextMenu((Object)this.getViewer().getTextWidget(), "miworkplace.ui.editor.markdown.ifs.popupmenu");
    }

    public Control getOutlinePage(Composite parent) {
        if (this.outlinePage == null) {
            this.buildOutlinePage(parent);
        }
        return this.outlinePage.getControl();
    }

    private void buildOutlinePage(Composite parent) {
        IEclipseContext pageContext = this.context.createChild();
        pageContext.set(Composite.class, (Object)parent);
        pageContext.set("connection", (Object)this.connectionName);
        pageContext.set("inputUri", (Object)this.inputUri);
        this.outlinePage = (MarkdownOutlinePage)ContextInjectionFactory.make(MarkdownOutlinePage.class, (IEclipseContext)pageContext);
    }
}

