/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.markdown;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.markdown.parser.Header;
import miworkplace.ui.editor.markdown.parser.HeaderHierarchy;
import miworkplace.ui.editor.markdown.parser.MarkdownTocParser;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class MarkdownOutlinePage {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    private TreeViewer viewer;
    private StackLayout defaultLayout;
    private Composite noOutline;
    private Composite defaultComposite;
    private MarkdownTocParser tocParser = new MarkdownTocParser();
    private String inputUri;

    @Inject
    public MarkdownOutlinePage(Composite parent, final ESelectionService selectionService, @Named(value="inputUri") String editorInputUri) {
        this.inputUri = editorInputUri;
        this.defaultComposite = new Composite(parent, 0);
        this.defaultLayout = new StackLayout();
        this.defaultComposite.setLayout((Layout)this.defaultLayout);
        this.noOutline = this.buildNoOutline(this.defaultComposite);
        this.viewer = new TreeViewer(this.defaultComposite, 768);
        this.viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement = ((ITreeSelection)event.getSelection()).getFirstElement();
                if (selectedElement instanceof Header) {
                    Header header = (Header)selectedElement;
                    HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                    eventProperties.put("line", header.line);
                    eventProperties.put("inputUri", MarkdownOutlinePage.this.inputUri);
                    MarkdownOutlinePage.this.eventBroker.post("miworkplace/editor/highlight/line", eventProperties);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element == null) {
                    return;
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
            }
        });
    }

    private Composite buildNoOutline(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.markdown_outline_none);
        return form;
    }

    @PreDestroy
    public void dispose() {
    }

    @Inject
    @Optional
    public void notifiedDocumentChanged(@UIEventTopic(value="miworkplace/editor/document/changed") Event event) {
        String editorInputUri = event.getProperty("inputUri").toString();
        if (!this.inputUri.equals(editorInputUri)) {
            return;
        }
        DocumentEvent documentEvent = (DocumentEvent)event.getProperty("org.eclipse.e4.data");
        try {
            HeaderHierarchy hierarchy = this.tocParser.parse(new StringReader(documentEvent.getDocument().get()));
            this.viewer.setInput((Object)hierarchy);
            this.viewer.expandAll();
        }
        catch (Exception e) {
            this.logger.log(1, "Could not parser ToC from Markdown text.", (Throwable)e);
        }
    }

    @Inject
    @Optional
    public void notifiedDocumentSet(@UIEventTopic(value="miworkplace/editor/document/set") Event event) {
        String editorInputUri = event.getProperty("inputUri").toString();
        if (!this.inputUri.equals(editorInputUri)) {
            return;
        }
        Document document = (Document)event.getProperty("org.eclipse.e4.data");
        try {
            HeaderHierarchy hierarchy = this.tocParser.parse(new StringReader(document.get()));
            this.viewer.setInput((Object)hierarchy);
            this.viewer.expandAll();
        }
        catch (Exception e) {
            this.logger.log(1, "Could not parser ToC from Markdown text.", (Throwable)e);
        }
    }

    public Control getControl() {
        return this.defaultComposite;
    }

    class OutlineContentProvider
    implements ITreeContentProvider {
        private final Object[] nullElements = new Object[0];

        OutlineContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HeaderHierarchy) {
                List<Header> headers = ((HeaderHierarchy)parentElement).headers;
                return headers.toArray(new Header[headers.size()]);
            }
            if (parentElement instanceof Header) {
                List<Header> headers = ((Header)parentElement).subHeaders;
                return headers.toArray(new Header[headers.size()]);
            }
            return this.nullElements;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            MarkdownOutlinePage.this.defaultLayout.topControl = newInput == null ? MarkdownOutlinePage.this.noOutline : (newInput instanceof HeaderHierarchy ? viewer.getControl() : MarkdownOutlinePage.this.noOutline);
            MarkdownOutlinePage.this.defaultComposite.layout(true);
        }
    }
}

