/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import miworkplace.ui.editor.rpg.ast.CommentIdentifier;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Token;

public class TokenProcessor {
    private List<String> compilerInstructions = Arrays.asList("**FREE", "**CTDATA", "**FTRANS", "**ALTSEQ");
    private List<String> compilerDirectives = Arrays.asList("/include", "/title", "/set", "/restore", "/if", "/endif", "/copy", "/define", "/eject", "/space", "/else", "/elseif", "/free", "/end-free", "/eof", "/undefine");

    public List<Statement> process(List<Token> tokens) {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        if (tokens.isEmpty()) {
            return statements;
        }
        AtomicInteger line = new AtomicInteger(tokens.get((int)0).line);
        Statement statement = new Statement();
        ListIterator<Token> iterator = tokens.listIterator();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            line.set(token.line);
            if (statement.size() == 0 && this.compilerInstructions.contains(token.value.toUpperCase())) {
                statement = this.processLine(iterator, token);
                statements.add(statement);
                statement = new Statement();
                continue;
            }
            if (statement.size() == 0 && this.compilerDirectives.contains(token.value.toLowerCase())) {
                statement = this.processLine(iterator, token);
                statements.add(statement);
                statement = new Statement();
                continue;
            }
            if (token instanceof CommentIdentifier) {
                statements.add(this.processLine(iterator, token));
                continue;
            }
            if (token.value.equals(";")) {
                statement.add(token);
                statements.add(statement);
                statement = new Statement();
                continue;
            }
            statement.add(token);
        }
        if (statement.size() > 0) {
            statements.add(statement);
        }
        return statements;
    }

    private Statement processLine(ListIterator<Token> iterator, Token token) {
        AtomicInteger line = new AtomicInteger(token.line);
        Statement statement = new Statement();
        boolean end = false;
        while (line.get() == token.line) {
            statement.add(token);
            if (!iterator.hasNext()) {
                end = true;
                break;
            }
            token = iterator.next();
        }
        if (!end) {
            token = iterator.previous();
        }
        return statement;
    }
}

