/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Parameter;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Token;

public class Module
extends Ast {
    private List<Procedure> procedures = new ArrayList<Procedure>();

    public Module(List<Statement> pStatements) {
        super(pStatements);
    }

    public void addProcedure(Procedure procedure) {
        this.procedures.add(procedure);
        this.addSymbol(procedure.getName(), procedure);
        List<Statement> statements = procedure.getStatements();
        Token firstToken = statements.get(0).list().get(0);
        List<Token> lastTokens = statements.get(statements.size() - 1).list();
        Token lastToken = lastTokens.get(lastTokens.size() - 1);
        this.scopes.put(Range.closed((Comparable)Integer.valueOf(firstToken.offset), (Comparable)Integer.valueOf(lastToken.offset + lastToken.value.length())), (Object)procedure);
        for (Parameter parameter : procedure.getProcedureInterface().getParameters()) {
            procedure.addSymbol(((AbstractVariable)((Object)parameter)).getName(), parameter);
        }
    }

    public List<Procedure> listProcedures() {
        return Collections.unmodifiableList(this.procedures);
    }
}

