/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.ast;

import java.util.LinkedList;
import java.util.List;
import miworkplace.ui.editor.rpg.ast.Element;
import miworkplace.ui.editor.rpg.ast.Statement;
import org.apache.commons.lang3.StringUtils;

public class File
extends Element {
    private String filename;
    private String externalDescription;
    private String externalDescriptionFile;
    private String externalDescriptionLibrary = "*LIBL";
    private boolean alias = false;
    private String likefile;
    private String prefix;
    private int prefixNumberReplacedCharacters = 0;
    private Type type;
    private boolean externallyDescribed = true;
    private List<String> ignoredRecordFormats = new LinkedList<String>();
    private List<String> includedRecordFormats = new LinkedList<String>();
    private boolean qualified = false;
    private String renamedRecordFormatExternal;
    private String renamedRecordFormatInternal;
    private boolean staticFile = false;
    private boolean template = false;

    public File(Statement statement) {
        super(statement);
    }

    @Deprecated
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
        this.setName(filename);
        if (this.externalDescriptionFile == null) {
            this.externalDescriptionFile = filename;
        }
    }

    public boolean useAlias() {
        return this.alias;
    }

    public void setUseAlias(boolean alias) {
        this.alias = alias;
    }

    public String getLikefile() {
        return this.likefile;
    }

    public void setLikefile(String likefile) {
        this.likefile = likefile;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Integer getPrefixNumberReplacedCharacters() {
        return this.prefixNumberReplacedCharacters;
    }

    public void setPrefixNumberReplacedCharacters(Integer prefixNumberReplacedCharacters) {
        this.prefixNumberReplacedCharacters = prefixNumberReplacedCharacters;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isExternallyDescribed() {
        return this.externallyDescribed;
    }

    public void setExternallyDescribed(boolean externallyDescribed) {
        this.externallyDescribed = externallyDescribed;
    }

    public List<String> getIgnoredRecordFormats() {
        return this.ignoredRecordFormats;
    }

    public void addIgnoredRecordFormat(String recordFormat) {
        this.ignoredRecordFormats.add(recordFormat);
    }

    public List<String> getIncludedRecordFormats() {
        return this.includedRecordFormats;
    }

    public void addIncludedRecordFormat(String recordFormat) {
        this.includedRecordFormats.add(recordFormat);
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public void setQualified(boolean qualified) {
        this.qualified = qualified;
    }

    public String getRenamedRecordFormatExternal() {
        return this.renamedRecordFormatExternal;
    }

    public void setRenamedRecordFormatExternal(String renamedRecordFormatExternal) {
        this.renamedRecordFormatExternal = renamedRecordFormatExternal;
    }

    public String getRenamedRecordFormatInternal() {
        return this.renamedRecordFormatInternal;
    }

    public void setRenamedRecordFormatInternal(String renamedRecordFormatInternal) {
        this.renamedRecordFormatInternal = renamedRecordFormatInternal;
    }

    public boolean isStaticFile() {
        return this.staticFile;
    }

    public void setStaticFile(boolean staticFile) {
        this.staticFile = staticFile;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public String toString() {
        return this.filename;
    }

    public String getExternalDescriptionFile() {
        return this.externalDescriptionFile;
    }

    public void setExternalDescriptionFile(String externalDescriptionFile) {
        this.externalDescriptionFile = externalDescriptionFile;
    }

    public String getExternalDescriptionLibrary() {
        return this.externalDescriptionLibrary;
    }

    public void setExternalDescriptionLibrary(String externalDescriptionLibrary) {
        this.externalDescriptionLibrary = externalDescriptionLibrary;
    }

    public String getExternalDescription() {
        return this.externalDescription;
    }

    public void setExternalDescription(String externalDescription) {
        this.externalDescription = externalDescription;
        String s = StringUtils.strip((String)externalDescription, (String)"'");
        if (s.contains("/")) {
            String[] parts = s.split("/");
            this.externalDescriptionLibrary = parts[0];
            this.externalDescriptionFile = parts[1];
        } else {
            this.externalDescriptionLibrary = "*LIBL";
            this.externalDescriptionFile = s;
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.likefile == null ? 0 : this.likefile.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + this.prefixNumberReplacedCharacters;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        File other = (File)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.likefile == null ? other.likefile != null : !this.likefile.equals(other.likefile)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.prefixNumberReplacedCharacters != other.prefixNumberReplacedCharacters) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Type {
        Disk,
        Printer,
        Workstation;

    }
}

