/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.log;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class ConsoleLogListener
implements LogListener {
    private static final String LOG_LEVEL_INFO = "INFO ";
    private static final String LOG_LEVEL_WARN = "WARN ";
    private static final String LOG_LEVEL_ERROR = "ERROR";
    private static final String LOG_LEVEL_DEBUG = "DEBUG";
    private static final String[] LOG_LEVELS = new String[]{"ERROR", "WARN ", "INFO ", "DEBUG"};
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String filterExpression = "$miworkplace.*";
    private File file;
    private int logLevel = 3;

    public void bindLogReader(LogReaderService logReader) {
        logReader.addLogListener((LogListener)this);
    }

    public void unbindLogReader(LogReaderService logReader) {
        logReader.removeLogListener((LogListener)this);
    }

    public void logged(LogEntry entry) {
        if (!this.isLoggable(entry)) {
            return;
        }
        String message = this.formatLogTime(entry.getTime()) + " " + this.formatLogLevel(entry.getLevel()) + " - " + entry.getBundle().getSymbolicName() + " - " + entry.getMessage();
        if (entry.getServiceReference() != null) {
            message = message + " - [ " + entry.getServiceReference().getClass().getName() + " (" + String.valueOf(entry.getServiceReference().getProperty("service.id")) + ") ]";
        }
        this.output(message);
    }

    private void output(String message) {
        System.out.println(message);
    }

    private String formatLogTime(long time) {
        return this.dateFormat.format(new Date(time));
    }

    private String formatLogLevel(int logLevel) {
        return LOG_LEVELS[--logLevel];
    }

    private boolean isLoggable(LogEntry entry) {
        boolean loggable = false;
        if (this.logLevel <= entry.getLevel()) {
            loggable = true;
        }
        return loggable;
    }
}

