/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search.handler;

import jakarta.inject.Inject;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ShowSearchResultHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;

    @Execute
    public void execute(ParameterizedCommand command) {
        Object queryId = command.getParameterMap().get("miworkplace.ui.search.show.query.id");
        if (queryId == null) {
            this.logger.debug((Option)miworkplace.ui.search.debug.Option.search, "No query id for Remote Search result passed to handler.");
            return;
        }
        this.logger.debug((Option)miworkplace.ui.search.debug.Option.search, "Showing Remote Search result for query " + String.valueOf(queryId));
        this.showSearchResultPart();
        this.eventBroker.post("miworkplace/ui/search/show", queryId);
    }

    private void showSearchResultPart() {
        MPart part = this.partService.findPart("miworkplace.ui.search.part.result");
        if (part == null) {
            part = this.partService.createPart("miworkplace.ui.search.part.result");
        }
        this.partService.showPart(part, EPartService.PartState.VISIBLE);
    }
}

