/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.ui.search.SearchResult;

public class SearchResultService {
    private Deque<SearchResult> searchResults = new LinkedList<SearchResult>();

    public void add(SearchResult searchResult) {
        for (SearchResult sr : this.searchResults) {
            if (!sr.getQuery().equals(searchResult.getQuery())) continue;
            this.searchResults.remove(sr);
            break;
        }
        this.searchResults.add(searchResult);
    }

    public void remove(SearchResult searchResult) {
        this.searchResults.remove(searchResult);
    }

    public void removeAll() {
        this.searchResults.clear();
    }

    public void removeByConnection(IConnection connection) {
        for (SearchResult searchResult : new LinkedList<SearchResult>(this.searchResults)) {
            if (!searchResult.getConnection().equals(connection)) continue;
            this.searchResults.remove(searchResult);
        }
    }

    public boolean isEmpty() {
        return this.searchResults.isEmpty();
    }

    public SearchResult latest() {
        return this.searchResults.isEmpty() ? null : this.searchResults.peek();
    }

    public SearchResult last() {
        return this.searchResults.isEmpty() ? null : this.searchResults.getLast();
    }

    public List<SearchResult> list() {
        return new LinkedList<SearchResult>(this.searchResults);
    }

    public SearchResult getByQueryId(long id) {
        for (SearchResult searchResult : this.searchResults) {
            if (searchResult.getQuery().getId() != id) continue;
            return searchResult;
        }
        return null;
    }
}

