/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.template;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import miworkplace.extra.xstream.XStream;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.template.Templates;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;

public class TemplateService
implements ITemplateService {
    private LogService logger;
    private EventAdmin eventAdmin;
    private List<Template> templates = new ArrayList<Template>();

    void bindLogService(LogService logger) {
        this.logger = logger;
    }

    void unbindLogService(LogService logger) {
        this.logger = null;
    }

    void bindEventAdmin(EventAdmin service) {
        this.eventAdmin = service;
    }

    void unbindEventAdmin(EventAdmin service) {
        this.eventAdmin = null;
    }

    public void activate() {
        File f = this.getPersistenceFile();
        if (!f.exists()) {
            try {
                List<Template> templates = this.buildInitialTemplates();
                this.internal_persist(templates);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.templates.addAll(this.load());
    }

    private List<Template> load() {
        File f = this.getPersistenceFile();
        if (f.exists()) {
            XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
            xstream.setClassLoader(this.getClass().getClassLoader());
            Templates templates = (Templates)xstream.fromXML(f);
            ArrayList<Template> unescapedTemplates = new ArrayList<Template>();
            for (Template t : templates.getTemplates()) {
                unescapedTemplates.add(t.unescapedCopy());
            }
            return unescapedTemplates;
        }
        return new ArrayList<Template>();
    }

    @Override
    public List<Template> get() {
        return new ArrayList<Template>(this.templates);
    }

    @Override
    public void persist(List<Template> templates) throws Exception {
        this.templates.clear();
        this.templates.addAll(templates);
        this.internal_persist(templates);
        Hashtable eventData = new Hashtable();
        this.eventAdmin.postEvent(new Event("miworkplace/ui/editor/template/persisted", eventData));
    }

    @Override
    public List<Template> deserialize(Reader in) {
        XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
        xstream.setClassLoader(this.getClass().getClassLoader());
        Templates templates = (Templates)xstream.fromXML(in);
        return templates.getTemplates();
    }

    @Override
    public void serialize(List<Template> templates, Writer writer) throws IOException {
        this.logger.log(4, "Serializing " + templates.size() + " templates");
        Templates container = new Templates();
        container.setTemplates(templates);
        XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
        xstream.setClassLoader(this.getClass().getClassLoader());
        xstream.toXML((Object)container, writer);
        writer.flush();
        writer.close();
        this.logger.log(4, "Serialized " + templates.size() + " templates");
    }

    private void internal_persist(List<Template> templates) throws IOException {
        File f = this.getPersistenceFile();
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        ArrayList<Template> escapedTemplates = new ArrayList<Template>();
        for (Template t : templates) {
            escapedTemplates.add(t.escapedCopy());
        }
        Templates container = new Templates();
        container.setTemplates(escapedTemplates);
        FileWriter writer = new FileWriter(f);
        XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
        xstream.setClassLoader(this.getClass().getClassLoader());
        xstream.toXML((Object)container, (Writer)writer);
        writer.close();
    }

    private File getPersistenceFile() {
        Bundle bundle = Platform.getBundle((String)"miworkplace.ui.editor");
        IPath bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
        IPath templatesPath = bundleStateLocation.append("templates").append("templates.xml");
        File f = templatesPath.toFile();
        return f;
    }

    private StaxDriver createSerializationDriverInstance() {
        return new StaxDriver();
    }

    @Override
    public List<Template> getSurroundWithTemplates(String category) {
        ArrayList<Template> surroundWithTemplates = new ArrayList<Template>();
        List<Template> templates = this.get();
        for (Template template : templates) {
            if (category != null && !template.getCategory().equals(category)) continue;
            if (template.getCode().contains("${word_selection}")) {
                surroundWithTemplates.add(template);
                continue;
            }
            if (!template.getCode().contains("${line_selection}")) continue;
            surroundWithTemplates.add(template);
        }
        return surroundWithTemplates;
    }

    private List<Template> buildInitialTemplates() {
        ArrayList<Template> templates = new ArrayList<Template>();
        Template t = new Template();
        t.setName("true");
        t.setContext("ILEDocs");
        t.setDescription("");
        t.setCode("<code>true</code>");
        templates.add(t);
        t = new Template();
        t.setName("false");
        t.setContext("ILEDocs");
        t.setDescription("");
        t.setCode("<code>false</code>");
        templates.add(t);
        t = new Template();
        t.setName("null");
        t.setContext("ILEDocs");
        t.setDescription("");
        t.setCode("<code>*null</code>");
        templates.add(t);
        t = new Template();
        t.setName("comment");
        t.setContext("CL");
        t.setDescription("comment");
        t.setCode("/*****************************************************************************/\n/* ${cursor}                                                                          */\n/*****************************************************************************/\n");
        templates.add(t);
        t = new Template();
        t.setName("dowhile");
        t.setContext("CL");
        t.setDescription("do while loop");
        t.setCode("DOWHILE ${condition}\n    ${cursor}\nENDDO\n");
        templates.add(t);
        t = new Template();
        t.setName("if");
        t.setContext("CL");
        t.setDescription("if structure");
        t.setCode("IF COND(${condition}) THEN(DO)\n    ${cursor}\nENDDO\n");
        templates.add(t);
        t = new Template();
        t.setName("select");
        t.setContext("CL");
        t.setDescription("select");
        t.setCode("SELECT\n    WHEN (${condition}) (${cursor})\nENDSELECT\n");
        templates.add(t);
        t = new Template();
        t.setName("subroutine");
        t.setContext("CL");
        t.setDescription("subroutine");
        t.setCode("SUBR SUBR(${name})\n    ${cursor}\nENDSUBR\n");
        templates.add(t);
        t = new Template();
        t.setName("comment");
        t.setContext("RPG");
        t.setDescription("multiline comment");
        t.setCode("/*\n * ${cursor}\n */\n");
        templates.add(t);
        t = new Template();
        t.setName("iledocs");
        t.setContext("RPG");
        t.setDescription("iledocs comment");
        t.setCode("/**\n * ${cursor}\n */\n");
        templates.add(t);
        t = new Template();
        t.setName("if");
        t.setContext("RPG");
        t.setDescription("if structure");
        t.setCode("if (${condition});\n    ${cursor}\nendif;\n");
        templates.add(t);
        t = new Template();
        t.setName("ifelse");
        t.setContext("RPG");
        t.setDescription("if else structure");
        t.setCode("if (${condition});\n    ${execute}\nelse;\n    ${cursor}\nendif;\n");
        templates.add(t);
        t = new Template();
        t.setName("ifelsif");
        t.setContext("RPG");
        t.setDescription("if elseif else structure");
        t.setCode("if (${condition1});\n    ${execute1}\nelseif (${condition2});\n    ${execute2}\nelse;\n    ${cursor}\nendif;\n");
        templates.add(t);
        t = new Template();
        t.setName("dowhile");
        t.setContext("RPG");
        t.setDescription("do while loop");
        t.setCode("dow (${condition1});\n    ${cursor}\nenddo;\n");
        templates.add(t);
        t = new Template();
        t.setName("for");
        t.setContext("RPG");
        t.setDescription("for loop");
        t.setCode("for i = ${start} TO ${end};\n    ${cursor}\nendfor;\n");
        templates.add(t);
        t = new Template();
        t.setName("select");
        t.setContext("RPG");
        t.setDescription("select");
        t.setCode("select;\nwhen (${condition});\n    ${cursor}\nendsl;\n");
        templates.add(t);
        t = new Template();
        t.setName("monitor");
        t.setContext("RPG");
        t.setDescription("error handling");
        t.setCode("monitor;\n    ${cursor}\non-error *all;\n    // TODO error handling\nendmon;\n");
        templates.add(t);
        t = new Template();
        t.setName("chain");
        t.setContext("RPG");
        t.setDescription("reading a file with a key");
        t.setCode("chain (${key}) ${file} ${datastructure};\nif (%found());\n    ${execute}\nelse;\n    ${cursor}\nendif;\n");
        templates.add(t);
        return templates;
    }
}

