/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.template;

import jakarta.inject.Named;
import java.util.Collection;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.IEditor;
import miworkplace.ui.editor.ColoredStyler;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.TemplateCompletionProposal;
import miworkplace.ui.editor.TemplateContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.osgi.service.log.LogService;

public class InsertSnippetHandler {
    @CanExecute
    public boolean canExecute(EPartService partService) {
        return this.getActiveEditableEditor(partService) != null;
    }

    @Execute
    public void execute(final EPartService partService, LogService logger, UISynchronize uiSync, @Optional @Named(value="org.eclipse.ui.selection") ITreeSelection selection, IEclipseContext context, IResourcePool imagePool, TemplateContext templateContext, @Optional MMenuItem menuItem) {
        Object value;
        boolean executedFromSurroundWithMenu = menuItem != null;
        Template template = null;
        if (menuItem != null && (value = menuItem.getTransientData().get("template")) != null) {
            template = (Template)value;
        }
        if (template == null && selection != null && selection.getFirstElement() instanceof Template) {
            template = (Template)selection.getFirstElement();
        }
        if (template == null) {
            throw new IllegalStateException(Messages.editor_template_snippets_noselection);
        }
        final MPart part = this.getActiveEditableEditor(partService);
        if (part != null) {
            IEditor editor = (IEditor)part.getObject();
            Point selectedRange = editor.getViewer().getSelectedRange();
            try {
                Image image = imagePool.getImageUnchecked("IMAGE_TEMPLATE");
                ColoredStyler stylerName = new ColoredStyler(imagePool.getColorUnchecked("COLOR_CONTENT_ASSIST_TEMPLATE"));
                ColoredStyler stylerDescription = new ColoredStyler(imagePool.getColorUnchecked("COLOR_CONTENT_ASSIST_DESCRIPTION"));
                TemplateCompletionProposal proposal = new TemplateCompletionProposal(template, image, stylerName, stylerDescription, templateContext);
                proposal.setExecutedFromSurroundWithMenu(executedFromSurroundWithMenu);
                proposal.apply(editor.getViewer(), ' ', -1, selectedRange.x);
                uiSync.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        partService.activate(part, true);
                    }
                });
            }
            catch (Exception e) {
                logger.log(1, "Could not insert template " + template.getName(), (Throwable)e);
                uiSync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.error((String)Messages.editor_template_snippets_notify_title, (String)Messages.editor_template_snippets_notify_msg);
                    }
                });
            }
        }
    }

    private MPart getActiveEditableEditor(EPartService partService) {
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            IEditor editor;
            if (!partService.isPartVisible(part) || part.getObject() == null || !(part.getObject() instanceof IEditor) || (editor = (IEditor)part.getObject()).isReadOnly()) continue;
            return part;
        }
        return null;
    }
}

