/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.pref;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.pref.TemplatesPreferenceNode;
import miworkplace.ui.editor.template.TemplateDialog;
import miworkplace.ui.editor.template.TemplateViewerComparator;
import miworkplace.ui.pref.api.PreferencePage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

class TemplatesPagePreferencePage
extends PreferencePage {
    private ITemplateService templateService;
    private TemplatesPreferenceNode node;
    private Button remove;
    private Button edit;
    private Button export;
    private Text preview;
    private TableViewer viewer;
    private List<Template> templates;
    private TemplateViewerComparator sorter;

    public TemplatesPagePreferencePage(Composite parent, TemplatesPreferenceNode node, ITemplateService templateService) {
        super(parent, 0);
        this.node = node;
        this.templateService = templateService;
        this.sorter = new TemplateViewerComparator();
        this.sorter.setCriteria(1);
        this.sorter.setSortDirection(false);
        this.templates = templateService.get();
        this.setLayout((Layout)new FillLayout());
        this.init((Composite)this);
    }

    private void init(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 25;
        form.getBody().setLayout((Layout)layout);
        form.setText(this.node.getName());
        Label description = toolkit.createLabel(form.getBody(), this.node.getDescription(), 64);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)description, 15);
        layoutData.left = new FormAttachment(0);
        Label l1 = toolkit.createLabel(form.getBody(), Messages.editor_pref_template_title + ":");
        l1.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)l1, 15);
        layoutData.right = new FormAttachment(100);
        layoutData.width = 90;
        Button add = toolkit.createButton(form.getBody(), Messages.common_add, 8);
        add.setLayoutData((Object)layoutData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Template t = new Template();
                TemplateDialog dialog = new TemplateDialog(TemplatesPagePreferencePage.this.getShell(), t);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    TemplatesPagePreferencePage.this.templates.add(t);
                    TemplatesPagePreferencePage.this.viewer.refresh();
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)add, 5);
        layoutData.left = new FormAttachment((Control)add, 0, 16384);
        layoutData.right = new FormAttachment(100);
        this.edit = toolkit.createButton(form.getBody(), Messages.common_edit, 8);
        this.edit.setLayoutData((Object)layoutData);
        this.edit.setEnabled(false);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Template t = (Template)((IStructuredSelection)TemplatesPagePreferencePage.this.viewer.getSelection()).getFirstElement();
                TemplateDialog dialog = new TemplateDialog(TemplatesPagePreferencePage.this.getShell(), t);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    TemplatesPagePreferencePage.this.viewer.refresh();
                    TemplatesPagePreferencePage.this.preview.setText(t.getCode());
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.edit, 5);
        layoutData.left = new FormAttachment((Control)this.edit, 0, 16384);
        layoutData.right = new FormAttachment(100);
        this.remove = toolkit.createButton(form.getBody(), Messages.common_remove, 8);
        this.remove.setLayoutData((Object)layoutData);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TemplatesPagePreferencePage.this.viewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                List selectedTemplates = selection.toList();
                TemplatesPagePreferencePage.this.templates.removeAll(selectedTemplates);
                TemplatesPagePreferencePage.this.viewer.refresh();
                TemplatesPagePreferencePage.this.preview.setText("");
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.remove, 5);
        layoutData.left = new FormAttachment((Control)this.remove, 0, 16384);
        layoutData.right = new FormAttachment(100);
        Button importing = toolkit.createButton(form.getBody(), Messages.common_import, 8);
        importing.setLayoutData((Object)layoutData);
        importing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(TemplatesPagePreferencePage.this.getShell(), 4096);
                dialog.setText(Messages.editor_pref_template_select);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String path = dialog.open();
                if (path != null) {
                    File f = new File(path);
                    if (f.exists() && f.canRead()) {
                        try {
                            List<Template> loadedTemplates = TemplatesPagePreferencePage.this.templateService.deserialize(new FileReader(f));
                            for (Template t : loadedTemplates) {
                                TemplatesPagePreferencePage.this.templates.remove(t);
                                TemplatesPagePreferencePage.this.templates.add(t);
                            }
                            TemplatesPagePreferencePage.this.viewer.refresh();
                            Notifier.info((String)Messages.editor_pref_template_import_title, (String)Messages.editor_pref_template_import_success);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (Exception ex) {
                            Notifier.error((String)Messages.editor_pref_template_import_title, (String)(Messages.editor_pref_template_import_error + ex.getMessage()));
                        }
                    } else {
                        Notifier.error((String)Messages.editor_pref_template_import_title, (String)Messages.editor_pref_template_import_notexist);
                    }
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)importing, 5);
        layoutData.left = new FormAttachment((Control)importing, 0, 16384);
        layoutData.right = new FormAttachment(100);
        this.export = toolkit.createButton(form.getBody(), Messages.common_export, 8);
        this.export.setLayoutData((Object)layoutData);
        this.export.setEnabled(false);
        this.export.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TemplatesPagePreferencePage.this.viewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                List selectedTemplates = selection.toList();
                FileDialog dialog = new FileDialog(TemplatesPagePreferencePage.this.getShell(), 8192);
                dialog.setText(Messages.editor_pref_template_select);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String path = dialog.open();
                if (path != null) {
                    File f = new File(path);
                    if (f.exists()) {
                        f.delete();
                    }
                    try {
                        f.createNewFile();
                        TemplatesPagePreferencePage.this.templateService.serialize(selectedTemplates, new FileWriter(f));
                        Notifier.info((String)Messages.editor_pref_template_export_title, (String)Messages.editor_pref_template_export_success);
                    }
                    catch (IOException ioe) {
                        Notifier.error((String)Messages.editor_pref_template_export_title, (String)(Messages.editor_pref_template_export_error + ioe.getMessage()));
                    }
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)add, 0, 128);
        layoutData.bottom = new FormAttachment(50);
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        layoutData.right = new FormAttachment((Control)add, -10, 16384);
        this.viewer = this.buildTableViewer(form.getBody());
        this.viewer.getControl().setLayoutData((Object)layoutData);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    TemplatesPagePreferencePage.this.edit.setEnabled(false);
                    TemplatesPagePreferencePage.this.remove.setEnabled(false);
                    TemplatesPagePreferencePage.this.export.setEnabled(false);
                    TemplatesPagePreferencePage.this.preview.setText("");
                } else {
                    TemplatesPagePreferencePage.this.edit.setEnabled(true);
                    TemplatesPagePreferencePage.this.remove.setEnabled(true);
                    TemplatesPagePreferencePage.this.export.setEnabled(true);
                    Template t = (Template)((IStructuredSelection)TemplatesPagePreferencePage.this.viewer.getSelection()).getFirstElement();
                    TemplatesPagePreferencePage.this.preview.setText(t.getCode());
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment(this.viewer.getControl(), 25);
        layoutData.left = new FormAttachment(0);
        Label l2 = toolkit.createLabel(form.getBody(), "Preview:");
        l2.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)l2, 15);
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(100);
        layoutData.bottom = new FormAttachment(100);
        this.preview = toolkit.createText(form.getBody(), null, 778);
        this.preview.setLayoutData((Object)layoutData);
        this.preview.setFont(JFaceResources.getTextFont());
        this.viewer.setInput(this.templates);
        toolkit.paintBordersFor(form.getBody());
    }

    private TableViewer buildTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 770);
        viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.modifyTable(viewer);
        return viewer;
    }

    private void modifyTable(TableViewer viewer) {
        Table table = viewer.getTable();
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText("Name");
        col1.setWidth(200);
        col1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(viewer, 1));
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setText("Context");
        col2.setWidth(100);
        col2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(viewer, 2));
        TableColumn col3 = new TableColumn(table, 16384);
        col3.setText("Category");
        col3.setWidth(100);
        col3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(viewer, 3));
        TableColumn col4 = new TableColumn(table, 16384);
        col4.setText("Description");
        col4.setWidth(200);
        col4.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(viewer, 4));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        viewer.setComparator((ViewerComparator)this.sorter);
    }

    public boolean isValid() {
        return true;
    }

    public void save(IEclipsePreferences preferences) {
        try {
            this.templateService.persist(this.templates);
        }
        catch (Exception e) {
            Notifier.error((String)Messages.common_save_pref, (String)(Messages.editor_pref_template_save_error + e.getMessage()));
        }
    }

    public void preShow() {
        this.viewer.setInput(this.templateService.get());
        this.viewer.refresh(true);
        this.viewer.getTable().update();
    }

    class ColumnSelectionAdapter
    extends SelectionAdapter {
        private final TableViewer viewer;
        private final int sortCriteria;

        public ColumnSelectionAdapter(TableViewer viewer, int sortCriteria) {
            this.viewer = viewer;
            this.sortCriteria = sortCriteria;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.viewer.getComparator() instanceof TemplateViewerComparator) {
                if (TemplatesPagePreferencePage.this.sorter.getCriteria() == this.sortCriteria) {
                    TemplatesPagePreferencePage.this.sorter.setCriteria(this.sortCriteria).setSortDirection(!TemplatesPagePreferencePage.this.sorter.getSortDirection());
                } else {
                    TemplatesPagePreferencePage.this.sorter.setCriteria(this.sortCriteria).setSortDirection(false);
                }
                this.viewer.refresh();
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof List) {
                return TemplatesPagePreferencePage.this.templates.toArray(new Template[TemplatesPagePreferencePage.this.templates.size()]);
            }
            return new Object[0];
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String text = null;
            switch (index) {
                case 0: {
                    text = ((Template)obj).getName();
                    break;
                }
                case 1: {
                    text = ((Template)obj).getContext();
                    break;
                }
                case 2: {
                    text = ((Template)obj).getCategory();
                    break;
                }
                case 3: {
                    text = ((Template)obj).getDescription();
                }
            }
            return text == null ? "" : text;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

