/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.include;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.MemberDescription;
import com.ibm.as400.access.MemberList;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectList;
import com.ibm.as400.access.QSYSObjectPathName;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.MiWorkplaceTraceException;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.ICompileCommandBuilder;
import miworkplace.ui.editor.IIncludePathResolver;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class IncludePathResolver
implements IIncludePathResolver {
    private Debug logger = Debug.getInstance();
    private ICompileCommandBuilder compileCommandBuilder;
    private IWorkspaceStore workspaceStore;
    private IConnectionManager connectionManager;

    public void bindCompileCommandBuilder(ICompileCommandBuilder builder) {
        this.compileCommandBuilder = builder;
    }

    public void unbindCompileCommandBuilder(ICompileCommandBuilder builder) {
        this.compileCommandBuilder = null;
    }

    public void bindWorkspaceStore(IWorkspaceStore workspaceStore) {
        this.workspaceStore = workspaceStore;
    }

    public void unbindWorkspaceStore(IWorkspaceStore workspaceStore) {
        this.workspaceStore = null;
    }

    public void bindConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void unbindConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = null;
    }

    @Override
    public String resolvePath(String includePath, String connectionName, String sourceFilePath) throws Exception {
        return this.resolvePath(includePath, connectionName, sourceFilePath, new String[0]);
    }

    @Override
    public String resolvePath(String includePath, String connectionName, String sourceFilePath, String[] incDirPaths) throws Exception {
        IConnection connection = this.connectionManager.get(connectionName);
        if (connection == null) {
            return null;
        }
        IRemoteObject sourceFile = this.workspaceStore.get(connection, sourceFilePath);
        if (sourceFile == null) {
            return null;
        }
        return this.resolvePath(includePath, sourceFile, incDirPaths);
    }

    @Override
    public String resolvePath(String includePath, IRemoteObject sourceFile) throws Exception {
        return this.resolvePath(includePath, sourceFile, new String[0]);
    }

    @Override
    public String resolvePath(String includePath, IRemoteObject sourceFile, String[] incDirPaths) throws Exception {
        String resolvedPath = null;
        IFSFile streamFile = this.getIncludeAsStreamfile(sourceFile, includePath, incDirPaths);
        if (streamFile != null) {
            return streamFile.getAbsolutePath();
        }
        try {
            resolvedPath = this.resolveIncludePath(sourceFile.getConnection(), includePath);
        }
        catch (Exception e) {
            this.logger.error("Could not resolve path as QSYS.LIB path: " + includePath + ".", (Throwable)e);
        }
        return resolvedPath;
    }

    private IFSFile getIncludeAsStreamfile(IRemoteObject source, String includePath, String[] paths) {
        Object basePath = "";
        try {
            if (includePath.startsWith("/")) {
                this.logger.debug((Option)miworkplace.ui.editor.debug.Option.loading, includePath + " is an absolute path. No base path required.");
                IFSFile file = this.getIncludeFile(source.getConnection(), includePath);
                if (file != null) {
                    return file;
                }
            } else {
                basePath = new IFSFile(source.getConnection().getSystem(), source.getPath()).getParent() + "/";
                IFSFile file = this.getIncludeFile(source.getConnection(), (String)basePath + includePath);
                if (file != null) {
                    return file;
                }
                basePath = StringUtils.defaultString((String)this.getIncludeDirectoryParameterFromCompileCommand(source));
                this.logger.debug((Option)miworkplace.ui.editor.debug.Option.loading, "Using + " + (String)basePath + " as a base path for " + includePath);
                if (!((String)basePath).isEmpty() && !((String)basePath).endsWith("/")) {
                    basePath = (String)basePath + "/";
                }
                if ((file = this.getIncludeFile(source.getConnection(), (String)basePath + includePath)) != null) {
                    return file;
                }
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    file = this.getIncludeFile(source.getConnection(), path + "/" + includePath);
                    if (file != null) {
                        return file;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private IFSFile getIncludeFile(IConnection connection, String path) throws IOException {
        IFSFile file = new IFSFile(connection.getSystem(), path);
        if (file.exists()) {
            return file;
        }
        if (FilenameUtils.getExtension((String)path).length() == 0) {
            file = new IFSFile(connection.getSystem(), path + ".rpgle");
            if (file.exists()) {
                return file;
            }
            file = new IFSFile(connection.getSystem(), path + ".rpgleinc");
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    private String getIncludeDirectoryParameterFromCompileCommand(IRemoteObject member) {
        int y;
        String icCommand;
        int x;
        String command = this.compileCommandBuilder.buildCommand(member);
        if (command != null && (x = (icCommand = command.toUpperCase()).indexOf("INCDIR(")) >= 0 && (y = icCommand.indexOf(")", x)) >= 0) {
            return StringUtils.strip((String)command.substring(x + 7, y), (String)"'\"");
        }
        return null;
    }

    private String resolveIncludePath(IConnection connection, String path) throws Exception {
        QSYSObjectPathName qsysPath = new QSYSObjectPathName();
        String[] pathParts = IncludePathResolver.fillQSYSPathParts(path);
        if (pathParts[0].equals("*CURLIB")) {
            try {
                pathParts[0] = connection.getSystem().getJobs(2)[0].getCurrentLibrary();
            }
            catch (Exception e) {
                this.logger.error("Could not determine current library. Using QGPL.", (Throwable)e);
                pathParts[0] = "QGPL";
            }
        }
        if (pathParts[0].equals("*LIBL")) {
            String resolveLibrary = this.resolveLibrary(connection, pathParts[1], pathParts[2]);
            if (resolveLibrary != null) {
                qsysPath.setLibraryName(resolveLibrary);
            } else {
                String msg = MessageFormat.format("Include path could not be found for {0}", path);
                this.logger.error(msg, (Throwable)new MiWorkplaceTraceException(msg));
            }
        } else {
            qsysPath.setLibraryName(pathParts[0]);
        }
        qsysPath.setObjectName(pathParts[1]);
        qsysPath.setMemberName(pathParts[2]);
        qsysPath.setObjectType("MBR");
        return qsysPath.getPath();
    }

    private static String[] fillQSYSPathParts(String path) {
        String[] retVal = new String[3];
        String[] pathParts = path.split("[\\/,]");
        if (pathParts.length == 3) {
            retVal[2] = pathParts[2].toUpperCase();
            retVal[1] = pathParts[1].toUpperCase();
            retVal[0] = pathParts[0].toUpperCase();
        } else if (pathParts.length == 2) {
            retVal[2] = pathParts[1].toUpperCase();
            retVal[1] = pathParts[0].toUpperCase();
            retVal[0] = "*LIBL";
        } else if (pathParts.length == 1) {
            retVal[2] = pathParts[0].toUpperCase();
            retVal[1] = "QRPGLESRC";
            retVal[0] = "*LIBL";
        }
        if (retVal[2] == null) {
            throw new RuntimeException(String.format(Messages.editor_handler_openinc_invalidqsyspath, path));
        }
        if (retVal[2].length() > 10) {
            throw new RuntimeException(String.format(Messages.editor_handler_openinc_invalidmemberpath, path));
        }
        return retVal;
    }

    private String resolveLibrary(IConnection connection, String filename, String memberName) throws Exception {
        ObjectList objectList = new ObjectList(connection.getSystem(), "*LIBL", filename, "*FILE");
        objectList.load();
        Enumeration listEnum = objectList.getObjects();
        while (listEnum.hasMoreElements()) {
            MemberDescription[] memberDescriptions;
            ObjectDescription objectDescription = (ObjectDescription)listEnum.nextElement();
            IRemoteObject remoteObject = this.workspaceStore.get(connection, objectDescription.getPath());
            if (remoteObject != null && remoteObject.areChildrenLoaded()) {
                List members = this.workspaceStore.getMembers(remoteObject);
                for (IRemoteObject member : members) {
                    if (!member.getName().equalsIgnoreCase(memberName)) continue;
                    return new QSYSObjectPathName(member.getPath()).getLibraryName();
                }
            }
            MemberList memberList = new MemberList(connection.getSystem(), objectDescription.getLibrary(), filename);
            memberList.addAttribute(3);
            memberList.addAttribute(1);
            memberList.addAttribute(2);
            memberList.load();
            MemberDescription[] memberDescriptionArray = memberDescriptions = memberList.getMemberDescriptions();
            int n = memberDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                MemberDescription memberDescription = memberDescriptionArray[n2];
                if (memberDescription.getValue(3).toString().equalsIgnoreCase(memberName)) {
                    return memberDescription.getValue(2).toString();
                }
                ++n2;
            }
        }
        return null;
    }
}

