/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.IEditor;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.text.TextSelection;

public class SurroundWithMenuContribution {
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private ITemplateService templateService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, ESelectionService selectionService, @Named(value="e4ActivePart") MPart part) {
        Object selection = selectionService.getSelection();
        if (!(selection instanceof TextSelection)) {
            return;
        }
        List<Template> templates = this.templateService.getSurroundWithTemplates(null);
        if (templates.isEmpty()) {
            MDirectMenuItem item = this.createNoMappingMenuItem();
            items.add((MMenuElement)item);
        } else {
            IEditor editor = (IEditor)part.getObject();
            for (Template template : templates) {
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                MCommand command = this.getCommandInstance("miworkplace.ui.editor.command.insertsnippet");
                dynamicItem.setLabel(template.getName());
                dynamicItem.setCommand(command);
                if (this.containsLineSelection(template)) {
                    dynamicItem.setIconURI("platform:/plugin/miworkplace.images/icons/selection-row.png");
                } else {
                    dynamicItem.setIconURI("platform:/plugin/miworkplace.images/icons/selection-word.png");
                }
                dynamicItem.getTransientData().put("template", template);
                dynamicItem.setEnabled(!editor.isReadOnly());
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private boolean containsLineSelection(Template template) {
        return template.getCode().contains("${line_selection}");
    }

    private MDirectMenuItem createNoMappingMenuItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.editor_handler_surroundwith_notemplates);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }

    private MCommand getCommandInstance(String commandId) {
        List commands = this.application.getCommands();
        for (MCommand command : commands) {
            if (!command.getElementId().equals(commandId)) continue;
            return command;
        }
        return null;
    }
}

