/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.osgi.service.log.LogService;

public class ShiftLeftHandler {
    @Inject
    private Adapter adapter;
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        boolean canDoOperation = part.getObject() instanceof IEditor;
        if (canDoOperation) {
            boolean bl = canDoOperation = !((IEditor)part.getObject()).isReadOnly();
        }
        if (canDoOperation) {
            boolean bl = canDoOperation = this.adapter.adapt(part.getObject(), IRewriteTarget.class) != null;
        }
        if (canDoOperation) {
            String[] positionCategories;
            String[] stringArray = positionCategories = ((IEditor)part.getObject()).getDocument().getPositionCategories();
            int n = positionCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                if (category.equals("miworkplace.template.proposal.category")) {
                    return false;
                }
                ++n2;
            }
        }
        return canDoOperation;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Preference(nodePath="miworkplace.application") IEclipsePreferences applicationPreferences) {
        block10: {
            boolean tabsToSpaces = applicationPreferences.getBoolean("miworkplace.ui.editor.spacesfortabs", true);
            Integer tabWidth = tabsToSpaces ? applicationPreferences.getInt("miworkplace.ui.editor.tabwidth", 4) : 1;
            ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
            IDocument document = viewer.getDocument();
            IRewriteTarget target = (IRewriteTarget)this.adapter.adapt(part.getObject(), IRewriteTarget.class);
            TextSelection selection = (TextSelection)viewer.getSelectionProvider().getSelection();
            try {
                if (selection.getLength() == 0) {
                    if (this.canShift(document, selection.getOffset(), tabWidth)) {
                        IRegion lineInfo = document.getLineInformationOfOffset(selection.getOffset());
                        document.replace(lineInfo.getOffset(), tabWidth.intValue(), "");
                    }
                    break block10;
                }
                if (!this.canShift(document, selection, tabWidth)) break block10;
                int selectionLength = selection.getLength();
                target.beginCompoundChange();
                try {
                    boolean selectedWholeLine;
                    int lineIndex = selection.getStartLine();
                    int endLine = selection.getEndLine();
                    while (lineIndex <= endLine) {
                        int lineLength = target.getDocument().getLineLength(lineIndex);
                        if (lineLength > tabWidth) {
                            int lineStart = target.getDocument().getLineOffset(lineIndex);
                            target.getDocument().replace(lineStart, tabWidth.intValue(), "");
                            selectionLength -= tabWidth.intValue();
                        }
                        ++lineIndex;
                    }
                    int selectionStart = selection.getOffset();
                    boolean bl = selectedWholeLine = document.getLineOffset(selection.getStartLine()) == selection.getOffset();
                    if (!selectedWholeLine) {
                        selectionStart -= tabWidth.intValue();
                        selectionLength += tabWidth.intValue();
                    }
                    viewer.setSelectedRange(selectionStart, selectionLength);
                }
                finally {
                    target.endCompoundChange();
                }
            }
            catch (BadLocationException e) {
                this.logger.log(1, "Could not shift line left. Error: " + e.getMessage());
            }
        }
    }

    private boolean canShift(IDocument document, TextSelection selection, Integer tabWidth) throws BadLocationException {
        boolean canDo = true;
        int lineIndex = selection.getStartLine();
        int endLine = selection.getEndLine();
        while (lineIndex <= endLine) {
            int lineStart = document.getLineOffset(lineIndex);
            if (StringUtils.isNotBlank((CharSequence)document.get(lineStart, tabWidth.intValue()))) {
                canDo = false;
            }
            ++lineIndex;
        }
        return canDo;
    }

    private boolean canShift(IDocument document, int offset, Integer tabWidth) throws BadLocationException {
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        if (lineInfo.getLength() > tabWidth) {
            String s = document.get(lineInfo.getOffset(), tabWidth.intValue());
            return StringUtils.isBlank((CharSequence)s);
        }
        return false;
    }
}

