/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import miworkplace.i18n.Messages;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;

class NumberRangeValidator
implements IInputValidator {
    private int numberLines;

    public NumberRangeValidator(int numberLines) {
        this.numberLines = numberLines;
    }

    public String isValid(String newText) {
        if (newText == null || newText.length() == 0) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)newText)) {
            try {
                int value = Integer.parseInt(newText);
                if (value > this.numberLines) {
                    return Messages.editor_handler_goto_outofrange;
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return Messages.editor_handler_goto_nan;
            }
        }
        return Messages.editor_handler_goto_nan;
    }
}

