/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.osgi.service.log.LogService;

public class MoveLineDownHandler {
    @Inject
    private LogService logger;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        TextSelection selection = (TextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getEndLine() == viewer.getDocument().getNumberOfLines() - 1) {
            return;
        }
        try {
            int startLine = selection.getStartLine();
            int endLine = selection.getEndLine();
            int startOffset = viewer.getDocument().getLineOffset(startLine);
            int nextLineLength = viewer.getDocument().getLineLength(endLine + 1);
            int targetEndOffset = viewer.getDocument().getLineOffset(endLine + 1) + nextLineLength;
            int totalLength = targetEndOffset - startOffset;
            String text = viewer.getDocument().get(startOffset, totalLength);
            boolean lastAndEmpty = selection.getEndLine() + 2 == viewer.getDocument().getNumberOfLines() && viewer.getDocument().getLineLength(viewer.getDocument().getNumberOfLines() - 1) == 0;
            text = this.switchLines(text, lastAndEmpty);
            viewer.getTextWidget().replaceTextRange(startOffset, totalLength, text);
            int newStartOffset = viewer.getDocument().getLineOffset(startLine + 1);
            int newEndOffset = viewer.getDocument().getLineOffset(endLine + 1) + viewer.getDocument().getLineLength(endLine + 1);
            viewer.revealRange(newStartOffset, 1);
            viewer.setSelectedRange(newStartOffset, newEndOffset - newStartOffset);
        }
        catch (BadLocationException e) {
            this.logger.log(4, "Could not move line up. Cause: " + e.getMessage());
        }
    }

    private String switchLines(String text, boolean lastAndEmpty) {
        if (lastAndEmpty) {
            return "\n" + text.substring(0, text.length() - 1);
        }
        if (text.endsWith("\n")) {
            int x = text.lastIndexOf("\n", text.length() - 2);
            return text.substring(x + 1) + text.substring(0, x + 1);
        }
        int x = text.lastIndexOf("\n");
        return text.substring(x + 1) + "\n" + text.substring(0, x);
    }

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        boolean canDoOperation;
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        TextSelection selection = (TextSelection)viewer.getSelectionProvider().getSelection();
        boolean bl = canDoOperation = selection.getEndLine() != viewer.getDocument().getNumberOfLines() - 1;
        if (canDoOperation) {
            canDoOperation = part.getObject() instanceof IEditor && !((IEditor)part.getObject()).isReadOnly();
        }
        return canDoOperation;
    }
}

