/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Named;
import java.util.Objects;
import miworkplace.common.debug.Debug;
import miworkplace.ui.api.IFindReplaceSupport;
import miworkplace.ui.editor.FindSearchData;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Point;

public class FindNextHandler {
    private Debug logger = Debug.getInstance();
    private static FindSearchData fPreviousFindData;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof IFindReplaceSupport;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Optional FindSearchData findData) {
        IFindReplaceSupport findReplaceSupportingObject = (IFindReplaceSupport)part.getObject();
        IDocument document = findReplaceSupportingObject.getDocument();
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
        int startOffset = 0;
        Point selectedRange = findReplaceSupportingObject.getViewer().getSelectedRange();
        try {
            if (selectedRange != null && selectedRange.x >= 0) {
                startOffset = selectedRange.x;
                String currentlySelectedText = document.get(selectedRange.x, selectedRange.y);
                if (currentlySelectedText.isEmpty() && fPreviousFindData != null) {
                    currentlySelectedText = FindNextHandler.fPreviousFindData.searchValue;
                }
                if (findData == null || !Objects.equals(currentlySelectedText, findData.searchValue)) {
                    findData = new FindSearchData();
                    findData.searchValue = currentlySelectedText;
                    findData.caseSensitive = false;
                    findData.direction = FindSearchData.Direction.forward;
                    findData.regex = false;
                    findData.wrapSearch = true;
                }
                if (currentlySelectedText.equalsIgnoreCase(findData.searchValue)) {
                    startOffset += selectedRange.y;
                }
            }
            if (findData == null) {
                return;
            }
            fPreviousFindData = findData;
            IRegion region = adapter.find(startOffset, findData.searchValue, true, findData.caseSensitive, false, findData.regex);
            if (region == null && findData.wrapSearch) {
                startOffset = 0;
                region = adapter.find(startOffset, findData.searchValue, true, findData.caseSensitive, false, findData.regex);
            }
            if (region != null) {
                findReplaceSupportingObject.getViewer().setSelectedRange(region.getOffset(), region.getLength());
                findReplaceSupportingObject.getViewer().revealRange(region.getOffset(), region.getLength());
            }
        }
        catch (BadLocationException e) {
            this.logger.error("Find Next action resulted in error.", (Throwable)e);
        }
    }
}

