/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.osgi.service.log.LogService;

public class DeleteLineHandler {
    @Inject
    private LogService logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        return part.getObject() instanceof IEditor && !((IEditor)part.getObject()).isReadOnly();
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextViewer viewer = ((IEditor)part.getObject()).getViewer();
        Point selectedRange = viewer.getSelectedRange();
        try {
            int currentLine = viewer.getDocument().getLineOfOffset(selectedRange.x + selectedRange.y);
            int startOffset = viewer.getDocument().getLineOffset(currentLine);
            int column = selectedRange.x - startOffset;
            int lineLength = viewer.getDocument().getLineLength(currentLine);
            boolean lastLine = currentLine == viewer.getDocument().getNumberOfLines() - 1;
            viewer.getTextWidget().replaceTextRange(startOffset, lineLength, "");
            if (lastLine) {
                viewer.setSelectedRange(viewer.getDocument().getLength(), 0);
            } else if (column > viewer.getDocument().getLineLength(currentLine)) {
                viewer.setSelectedRange(startOffset + viewer.getDocument().getLineLength(currentLine) - 1, 0);
            } else {
                viewer.setSelectedRange(startOffset + column, 0);
            }
        }
        catch (BadLocationException e) {
            this.logger.log(4, "Could not delete line. Cause: " + e.getMessage());
        }
    }
}

