/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import miworkplace.ui.editor.diff.ChangeDelta;
import miworkplace.ui.editor.diff.Chunk;
import miworkplace.ui.editor.diff.DeleteDelta;
import miworkplace.ui.editor.diff.Delta;
import miworkplace.ui.editor.diff.DiffRow;
import miworkplace.ui.editor.diff.DiffUtils;
import miworkplace.ui.editor.diff.InsertDelta;
import miworkplace.ui.editor.diff.Patch;
import miworkplace.ui.editor.diff.StringUtills;

public class DiffRowGenerator {
    private final boolean showInlineDiffs;
    private final boolean ignoreWhiteSpaces;
    private final boolean ignoreBlankLines;
    private final String InlineOldTag;
    private final String InlineNewTag;
    private final String InlineOldCssClass;
    private final String InlineNewCssClass;
    private final int columnWidth;

    private DiffRowGenerator(Builder builder) {
        this.showInlineDiffs = builder.showInlineDiffs;
        this.ignoreWhiteSpaces = builder.ignoreWhiteSpaces;
        this.ignoreBlankLines = builder.ignoreBlankLines;
        this.InlineOldTag = builder.InlineOldTag;
        this.InlineNewTag = builder.InlineNewTag;
        this.InlineOldCssClass = builder.InlineOldCssClass;
        this.InlineNewCssClass = builder.InlineNewCssClass;
        this.columnWidth = builder.columnWidth;
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised) {
        return this.generateDiffRows(original, revised, DiffUtils.diff(original, revised));
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised, Patch patch) {
        original = StringUtills.normalize(original);
        revised = StringUtills.normalize(revised);
        original = StringUtills.wrapText(original, this.columnWidth);
        revised = StringUtills.wrapText(revised, this.columnWidth);
        ArrayList<DiffRow> diffRows = new ArrayList<DiffRow>();
        int endPos = 0;
        List<Delta> deltaList = patch.getDeltas();
        int i = 0;
        while (i < deltaList.size()) {
            Delta delta = deltaList.get(i);
            Chunk orig = delta.getOriginal();
            Chunk rev = delta.getRevised();
            orig.setLines(StringUtills.normalize(orig.getLines()));
            rev.setLines(StringUtills.normalize(rev.getLines()));
            orig.setLines(StringUtills.wrapText(orig.getLines(), this.columnWidth));
            rev.setLines(StringUtills.wrapText(rev.getLines(), this.columnWidth));
            for (String line : original.subList(endPos, orig.getPosition())) {
                diffRows.add(new DiffRow(DiffRow.Tag.EQUAL, line, line));
            }
            if (delta.getClass().equals(InsertDelta.class)) {
                endPos = orig.last() + 1;
                for (String line : rev.getLines()) {
                    diffRows.add(new DiffRow(DiffRow.Tag.INSERT, "", line));
                }
            } else if (delta.getClass().equals(DeleteDelta.class)) {
                endPos = orig.last() + 1;
                for (String line : orig.getLines()) {
                    diffRows.add(new DiffRow(DiffRow.Tag.DELETE, line, ""));
                }
            } else {
                if (this.showInlineDiffs) {
                    this.addInlineDiffs(delta);
                }
                if (orig.size() == rev.size()) {
                    j = 0;
                    while (j < orig.size()) {
                        diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, (String)orig.getLines().get(j), (String)rev.getLines().get(j)));
                        ++j;
                    }
                } else if (orig.size() > rev.size()) {
                    j = 0;
                    while (j < orig.size()) {
                        diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, (String)orig.getLines().get(j), rev.getLines().size() > j ? (String)rev.getLines().get(j) : ""));
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < rev.size()) {
                        diffRows.add(new DiffRow(DiffRow.Tag.CHANGE, orig.getLines().size() > j ? (String)orig.getLines().get(j) : "", (String)rev.getLines().get(j)));
                        ++j;
                    }
                }
                endPos = orig.last() + 1;
            }
            ++i;
        }
        for (String line : original.subList(endPos, original.size())) {
            diffRows.add(new DiffRow(DiffRow.Tag.EQUAL, line, line));
        }
        return diffRows;
    }

    private void addInlineDiffs(Delta delta) {
        List<?> orig = delta.getOriginal().getLines();
        List<?> rev = delta.getRevised().getLines();
        LinkedList<String> origList = new LinkedList<String>();
        char[] cArray = DiffRowGenerator.join(orig, "\n").toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character character = Character.valueOf(cArray[n2]);
            origList.add(character.toString());
            ++n2;
        }
        LinkedList<String> revList = new LinkedList<String>();
        char[] cArray2 = DiffRowGenerator.join(rev, "\n").toCharArray();
        int n3 = cArray2.length;
        n = 0;
        while (n < n3) {
            Character character = Character.valueOf(cArray2[n]);
            revList.add(character.toString());
            ++n;
        }
        List<Delta> inlineDeltas = DiffUtils.diff(origList, revList).getDeltas();
        if (inlineDeltas.size() < 3) {
            Collections.reverse(inlineDeltas);
            for (Delta inlineDelta : inlineDeltas) {
                Chunk inlineOrig = inlineDelta.getOriginal();
                Chunk inlineRev = inlineDelta.getRevised();
                if (inlineDelta.getClass().equals(DeleteDelta.class)) {
                    origList = DiffRowGenerator.wrapInTag(origList, inlineOrig.getPosition(), inlineOrig.getPosition() + inlineOrig.size() + 1, this.InlineOldTag, this.InlineOldCssClass);
                    continue;
                }
                if (inlineDelta.getClass().equals(InsertDelta.class)) {
                    revList = DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size() + 1, this.InlineNewTag, this.InlineNewCssClass);
                    continue;
                }
                if (!inlineDelta.getClass().equals(ChangeDelta.class)) continue;
                origList = DiffRowGenerator.wrapInTag(origList, inlineOrig.getPosition(), inlineOrig.getPosition() + inlineOrig.size() + 1, this.InlineOldTag, this.InlineOldCssClass);
                revList = DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size() + 1, this.InlineNewTag, this.InlineNewCssClass);
            }
            StringBuilder origResult = new StringBuilder();
            StringBuilder revResult = new StringBuilder();
            for (String character : origList) {
                origResult.append(character);
            }
            for (String character : revList) {
                revResult.append(character);
            }
            delta.getOriginal().setLines(Arrays.asList(origResult.toString().split("\n")));
            delta.getRevised().setLines(Arrays.asList(revResult.toString().split("\n")));
        }
    }

    public static LinkedList<String> wrapInTag(LinkedList<String> sequence, int startPosition, int endPosition, String tag, String cssClass) {
        LinkedList result = (LinkedList)sequence.clone();
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("<");
        tagBuilder.append(tag);
        if (cssClass != null) {
            tagBuilder.append(" class=\"");
            tagBuilder.append(cssClass);
            tagBuilder.append("\"");
        }
        tagBuilder.append(">");
        String startTag = tagBuilder.toString();
        tagBuilder.delete(0, tagBuilder.length());
        tagBuilder.append("</");
        tagBuilder.append(tag);
        tagBuilder.append(">");
        String endTag = tagBuilder.toString();
        result.add(startPosition, startTag);
        result.add(endPosition, endTag);
        return result;
    }

    public static String wrapInTag(String line, String tag, String cssClass) {
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("<");
        tagBuilder.append(tag);
        if (cssClass != null) {
            tagBuilder.append(" class=\"");
            tagBuilder.append(cssClass);
            tagBuilder.append("\"");
        }
        tagBuilder.append(">");
        String startTag = tagBuilder.toString();
        tagBuilder.delete(0, tagBuilder.length());
        tagBuilder.append("</");
        tagBuilder.append(tag);
        tagBuilder.append(">");
        String endTag = tagBuilder.toString();
        return startTag + line + endTag;
    }

    private static <T> String join(Iterable<T> objs, String delimiter) {
        Iterator<T> iter = objs.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(iter.next()));
        while (iter.hasNext()) {
            buffer.append(delimiter).append(String.valueOf(iter.next()));
        }
        return buffer.toString();
    }

    public static class Builder {
        private boolean showInlineDiffs = false;
        private boolean ignoreWhiteSpaces = true;
        private boolean ignoreBlankLines = true;
        private String InlineOldTag = "span";
        private String InlineNewTag = "span";
        private String InlineOldCssClass = "editOldInline";
        private String InlineNewCssClass = "editNewInline";
        private int columnWidth = 80;

        public Builder showInlineDiffs(boolean val) {
            this.showInlineDiffs = val;
            return this;
        }

        public Builder ignoreWhiteSpaces(boolean val) {
            this.ignoreWhiteSpaces = val;
            return this;
        }

        public Builder ignoreBlankLines(boolean val) {
            this.ignoreBlankLines = val;
            return this;
        }

        public Builder InlineOldTag(String tag) {
            this.InlineOldTag = tag;
            return this;
        }

        public Builder InlineNewTag(String tag) {
            this.InlineNewTag = tag;
            return this;
        }

        public Builder InlineOldCssClass(String cssClass) {
            this.InlineOldCssClass = cssClass;
            return this;
        }

        public Builder InlineNewCssClass(String cssClass) {
            this.InlineNewCssClass = cssClass;
            return this;
        }

        public Builder columnWidth(int width) {
            if (width > 0) {
                this.columnWidth = width;
            }
            return this;
        }

        public DiffRowGenerator build() {
            return new DiffRowGenerator(this);
        }
    }
}

