/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.diff;

import java.util.List;
import miworkplace.ui.editor.diff.Chunk;
import miworkplace.ui.editor.diff.Delta;
import miworkplace.ui.editor.diff.PatchFailedException;

public class DeleteDelta
extends Delta {
    public DeleteDelta(Chunk original, Chunk revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<Object> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
    }

    @Override
    public void restore(List<Object> target) {
        int position = this.getRevised().getPosition();
        List<?> lines = this.getOriginal().getLines();
        int i = 0;
        while (i < lines.size()) {
            target.add(position + i, lines.get(i));
            ++i;
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.DELETE;
    }

    @Override
    public void verify(List<?> target) throws PatchFailedException {
        this.getOriginal().verify(target);
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getOriginal().getPosition() + ", lines: " + String.valueOf(this.getOriginal().getLines()) + "]";
    }
}

