/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.composites;

import java.text.MessageFormat;
import miworkplace.images.service.Factory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class OopsComposite
extends Composite {
    private StyledText fMessage;
    private static int fCounter;
    private Label fLblcloseAndOpen;

    public OopsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        CTabFolder tabFolder = new CTabFolder((Composite)this, 1024);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        CTabItem messageItem = new CTabItem(tabFolder, 0);
        messageItem.setText("Message");
        Composite messageComposite = new Composite((Composite)tabFolder, 0);
        messageComposite.setBackground(Display.getCurrent().getSystemColor(29));
        messageItem.setControl((Control)messageComposite);
        messageComposite.setLayout((Layout)new GridLayout(1, false));
        new Label(messageComposite, 0);
        new Label(messageComposite, 0);
        new Label(messageComposite, 0);
        Label lblSomethingWentWrong = new Label(messageComposite, 0);
        FontData[] fontData = lblSomethingWentWrong.getFont().getFontData();
        fontData[0].setHeight(18);
        lblSomethingWentWrong.setBackground(Display.getCurrent().getSystemColor(37));
        lblSomethingWentWrong.setFont(Factory.create((Widget)lblSomethingWentWrong, (FontData[])fontData));
        lblSomethingWentWrong.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        lblSomethingWentWrong.setText("Something went wrong...");
        new Label(messageComposite, 0);
        Label lblCloseTheEditor = new Label(messageComposite, 0);
        lblCloseTheEditor.setBackground(Display.getCurrent().getSystemColor(37));
        fontData[0].setHeight(14);
        lblCloseTheEditor.setFont(Factory.create((Widget)lblCloseTheEditor, (FontData[])fontData));
        lblCloseTheEditor.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblCloseTheEditor.setText("Please close the editor and try again.");
        new Label(messageComposite, 0);
        this.fLblcloseAndOpen = new Label(messageComposite, 0);
        fontData[0].setHeight(8);
        this.fLblcloseAndOpen.setFont(Factory.create((Widget)lblCloseTheEditor, (FontData[])fontData));
        this.fLblcloseAndOpen.setBackground(Display.getCurrent().getSystemColor(37));
        this.fLblcloseAndOpen.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.fLblcloseAndOpen.setText("(If the problem persists, close and open the connection, or restart)");
        this.fLblcloseAndOpen.setVisible(false);
        CTabItem detailsItem = new CTabItem(tabFolder, 0);
        detailsItem.setText("Details");
        Composite detailsComposite = new Composite((Composite)tabFolder, 0);
        detailsComposite.setBackground(Display.getCurrent().getSystemColor(29));
        detailsItem.setControl((Control)detailsComposite);
        detailsComposite.setLayout((Layout)new FillLayout(256));
        this.fMessage = new StyledText(detailsComposite, 8);
        this.fMessage.setBackground(Display.getCurrent().getSystemColor(37));
        this.fMessage.setRightMargin(5);
        this.fMessage.setLeftMargin(5);
        this.fMessage.setIndent(5);
        this.fMessage.setText("");
        if (fCounter > 1) {
            this.fLblcloseAndOpen.setVisible(true);
        }
        tabFolder.setSelection(messageItem);
    }

    public void setMessage(IStatus pStatus) {
        StyleRange styleRange;
        String[] message = this.getMessage(pStatus);
        this.fMessage.setText(message[0]);
        if (message[1] != null) {
            styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = message[1].length();
            styleRange.fontStyle = 1;
            this.fMessage.setStyleRange(styleRange);
        }
        if (message[2] != null) {
            styleRange = new StyleRange();
            styleRange.start = message[0].indexOf(message[2]);
            styleRange.length = message[2].length();
            styleRange.fontStyle = 1;
            this.fMessage.setStyleRange(styleRange);
        }
        if (message[3] != null) {
            styleRange = new StyleRange();
            styleRange.start = message[0].indexOf(message[3]);
            styleRange.length = message[3].length();
            styleRange.fontStyle = 1;
            this.fMessage.setStyleRange(styleRange);
        }
        this.requestLayout();
    }

    public void setCounter(int count) {
        if (count == 1) {
            ++fCounter;
        }
        if (count == 0) {
            fCounter = 0;
        }
        if (count == -1) {
            --fCounter;
        }
        this.fLblcloseAndOpen.setVisible(false);
        if (fCounter > 1) {
            this.fLblcloseAndOpen.setVisible(true);
        }
    }

    private String[] getMessage(IStatus pStatus) {
        String[] result = new String[4];
        Object message = pStatus.getMessage();
        if (message == null) {
            message = "";
        }
        result[1] = message;
        message = (String)message + System.lineSeparator();
        Throwable exception = pStatus.getException();
        if (exception != null) {
            message = (String)message + System.lineSeparator();
            message = (String)message + exception.getMessage();
            result[2] = exception.getMessage();
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement traceElement = stackTraceElementArray[n2];
                message = (String)message + System.lineSeparator();
                message = (String)message + "\t\t" + traceElement.toString();
                ++n2;
            }
            if (exception.getCause() != null) {
                message = (String)message + System.lineSeparator();
                message = (String)message + System.lineSeparator();
                String cause = MessageFormat.format("Caused by: {0}", exception.getCause().getMessage());
                message = (String)message + cause;
                result[3] = cause;
                StackTraceElement[] stackTraceElementArray2 = exception.getCause().getStackTrace();
                int n3 = stackTraceElementArray2.length;
                n = 0;
                while (n < n3) {
                    StackTraceElement traceElement = stackTraceElementArray2[n];
                    message = (String)message + System.lineSeparator();
                    message = (String)message + "\t\t" + traceElement.toString();
                    ++n;
                }
            }
        }
        result[0] = message;
        return result;
    }

    protected void checkSubclass() {
    }
}

