/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import miworkplace.ui.editor.AbstractCompletionProposal;
import miworkplace.ui.editor.LineVariableResolver;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.TemplateBuffer;
import miworkplace.ui.editor.TemplateContext;
import miworkplace.ui.editor.TemplateVariable;
import miworkplace.ui.editor.WordVariableResolver;
import miworkplace.ui.themes.Colors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class TemplateCompletionProposal
extends AbstractCompletionProposal {
    private final Template template;
    private final Image image;
    private final StyledString.Styler stylerName;
    private final StyledString.Styler stylerDescription;
    private InclusivePositionUpdater updater;
    private IRegion selectedRegion;
    private ISourceViewer sourceViewer;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private TemplateContext templateContext;
    private boolean executedFromSurroundWithMenu = false;

    public TemplateCompletionProposal(Template template, Image image, StyledString.Styler stylerName, StyledString.Styler stylerDescription, TemplateContext templateContext) {
        super(template.getName(), template.getDescription());
        this.template = template;
        this.image = image;
        this.stylerName = stylerName;
        this.stylerDescription = stylerDescription;
        this.templateContext = templateContext;
    }

    @Override
    public String getDisplayString() {
        return this.template.getName();
    }

    @Override
    public StyledString getStyledDisplayString() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            return new StyledString(this.code, this.stylerName);
        }
        StyledString string = new StyledString(this.code, this.stylerName);
        string.append(" - " + this.description, this.stylerDescription);
        return string;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public String getApplyString() {
        return this.template.getCode();
    }

    @Override
    public boolean isValidFor(IDocument document, int offset) {
        String currentValue = this.computeCurrentValue(document, offset);
        if (currentValue != null) {
            return this.template.getName().startsWith(currentValue);
        }
        return false;
    }

    @Override
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.template.getCode() == null || this.template.getCode().length() == 0) {
            return null;
        }
        RGB foreground = Colors.instance().get(Colors.ColorDefinition.DefaultFont).getRGB();
        RGB background = Colors.instance().get(Colors.ColorDefinition.DefaultBackground).getRGB();
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)foreground, (RGB)background, (String)this.getCSSStyles());
        buffer.append("<pre>");
        buffer.append(StringEscapeUtils.escapeHtml4((String)this.template.getCode()));
        buffer.append("</pre>");
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        String info = buffer.toString();
        return info;
    }

    public void setExecutedFromSurroundWithMenu(boolean executedFromSurroundWithMenu) {
        this.executedFromSurroundWithMenu = executedFromSurroundWithMenu;
    }

    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        String lineSelection;
        this.selectedRegion = null;
        IDocument document = viewer.getDocument();
        this.sourceViewer = (ISourceViewer)viewer;
        String wordSelection = this.getSelectedText(viewer);
        if (wordSelection != null) {
            this.templateContext.addResolver(new WordVariableResolver(wordSelection));
        }
        if ((lineSelection = this.getSelectedLines(viewer)) != null) {
            this.templateContext.addResolver(new LineVariableResolver(lineSelection));
        }
        TemplateBuffer evaluatedTemplateBuffer = null;
        String currentValue = "";
        try {
            if (this.containsLineSelection()) {
                selectedRange = viewer.getSelectedRange();
                currentLineInfo = document.getLineInformationOfOffset(selectedRange.x);
                numberIndentation = this.determineIndentationLevel(document.get(currentLineInfo.getOffset(), currentLineInfo.getLength()));
                this.deleteSelectedLines(viewer);
                indentedContent = this.indentContent(this.template.getCode(), numberIndentation, false);
                evaluatedTemplateBuffer = this.templateContext.evaluate(new TemplateBuffer(indentedContent));
                this.replacementString = evaluatedTemplateBuffer.getContent();
                document.replace(currentLineInfo.getOffset(), 0, this.replacementString);
            } else {
                selectedRange = viewer.getSelectedRange();
                if (selectedRange != null && selectedRange.y > 0) {
                    document.replace(selectedRange.x, selectedRange.y, "");
                }
                currentValue = this.executedFromSurroundWithMenu ? "" : this.computeCurrentValue(document, offset);
                currentLineInfo = document.getLineInformationOfOffset(offset);
                numberIndentation = offset - currentLineInfo.getOffset() - currentValue.length();
                indentedContent = this.indentContent(this.template.getCode(), numberIndentation, true);
                evaluatedTemplateBuffer = this.templateContext.evaluate(new TemplateBuffer(indentedContent));
                this.replacementString = evaluatedTemplateBuffer.getContent();
                document.replace(offset - currentValue.length(), currentValue.length(), this.replacementString);
            }
            this.cursorPosition = offset;
            TemplateVariable cursorVariable = evaluatedTemplateBuffer.getCursorVariable();
            if (evaluatedTemplateBuffer.getUnresolvedVariables().length > 0) {
                LinkedModeModel model = new LinkedModeModel();
                this.ensurePositionCategoryInstalled(document, model);
                TemplateVariable[] templateVariableArray = evaluatedTemplateBuffer.getUnresolvedVariables();
                int n = templateVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplateVariable variable = templateVariableArray[n2];
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int i = 0;
                    while (i < variable.getOffsets().length) {
                        Integer variableOffset = variable.getOffsets()[i];
                        int templateVariableOffsetInDocument = offset + variableOffset - currentValue.length();
                        Position pos = new Position(templateVariableOffsetInDocument, variable.getLength());
                        document.addPosition(this.getCategory(), pos);
                        Annotation annotation = new Annotation("miworkplace.ui.editor.annotation.variable", false, variable.getName());
                        this.annotations.add(annotation);
                        this.sourceViewer.getAnnotationModel().addAnnotation(annotation, pos);
                        if (variable.getOffsets().length == 1) {
                            group.addPosition(new LinkedPosition(document, templateVariableOffsetInDocument, variable.getLength()));
                        } else {
                            group.addPosition(new LinkedPosition(document, templateVariableOffsetInDocument, variable.getLength(), i));
                        }
                        ++i;
                    }
                    model.addGroup(group);
                    ++n2;
                }
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                if (cursorVariable != null) {
                    ui.setExitPosition(viewer, offset + cursorVariable.getOffsets()[0] - currentValue.length(), 0, Integer.MAX_VALUE);
                } else {
                    ui.setExitPosition(viewer, offset + this.replacementString.length() - currentValue.length(), 0, Integer.MAX_VALUE);
                }
                ui.enter();
                this.selectedRegion = ui.getSelectedRegion();
            } else {
                this.selectedRegion = cursorVariable == null ? new Region(offset + this.replacementString.length() - currentValue.length(), 0) : new Region(offset + cursorVariable.getOffsets()[0] - currentValue.length(), 0);
                this.ensurePositionCategoryRemoved(document);
                this.removeAnnotations(this.sourceViewer);
            }
        }
        catch (Exception e) {
            this.ensurePositionCategoryRemoved(document);
            this.removeAnnotations(this.sourceViewer);
            throw new RuntimeException(e);
        }
    }

    private void deleteSelectedLines(ITextViewer viewer) throws Exception {
        Point selectedRange = viewer.getSelectedRange();
        int selectionEnd = selectedRange.x + selectedRange.y;
        IDocument document = viewer.getDocument();
        IRegion lineInfo = document.getLineInformationOfOffset(selectedRange.x);
        int lineEnd = lineInfo.getOffset() + lineInfo.getLength();
        int deletionLength = 0;
        if (lineEnd >= selectionEnd) {
            deletionLength = lineInfo.getLength();
        } else {
            IRegion lastLineInfo = document.getLineInformationOfOffset(selectionEnd);
            deletionLength = lastLineInfo.getOffset() + lastLineInfo.getLength() - lineInfo.getOffset();
        }
        if (document.getLength() > lineInfo.getOffset() + deletionLength) {
            ++deletionLength;
        }
        document.replace(lineInfo.getOffset(), deletionLength, "");
    }

    private String getSelectedText(ITextViewer viewer) {
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y == 0) {
            return null;
        }
        try {
            String selectedText = viewer.getDocument().get(selectedRange.x, selectedRange.y);
            return selectedText;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String getSelectedLines(ITextViewer viewer) {
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y == 0) {
            return null;
        }
        int selectionEnd = selectedRange.x + selectedRange.y;
        try {
            IDocument document = viewer.getDocument();
            IRegion lineInfo = document.getLineInformationOfOffset(selectedRange.x);
            int lineEnd = lineInfo.getOffset() + lineInfo.getLength();
            if (lineEnd >= selectionEnd) {
                return viewer.getDocument().get(lineInfo.getOffset(), lineInfo.getLength()).trim();
            }
            IRegion lastLineInfo = document.getLineInformationOfOffset(selectionEnd);
            int linesLength = lastLineInfo.getOffset() + lastLineInfo.getLength() - lineInfo.getOffset();
            String[] selectedLines = document.get(lineInfo.getOffset(), linesLength).split("\n");
            int baseIndentationLevel = this.determineIndentationLevel(selectedLines[0]);
            int lineSelectionIndentation = this.determineTemplateLineSelectionIndentation();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selectedLines.length) {
                String line = selectedLines[i];
                int indentationLevel = this.determineIndentationLevel(line);
                if (baseIndentationLevel == indentationLevel) {
                    if (i != 0) {
                        sb.append(StringUtils.repeat((char)' ', (int)(baseIndentationLevel + lineSelectionIndentation)));
                    }
                    sb.append(line.trim());
                } else if (baseIndentationLevel > indentationLevel) {
                    sb.append(StringUtils.repeat((char)' ', (int)(baseIndentationLevel - indentationLevel + lineSelectionIndentation)));
                    sb.append(line.trim());
                } else {
                    sb.append(StringUtils.repeat((char)' ', (int)(baseIndentationLevel + lineSelectionIndentation)));
                    sb.append(line.substring(baseIndentationLevel));
                }
                sb.append("\n");
                ++i;
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private int determineIndentationLevel(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return s.length();
    }

    private String indentContent(String content, int numberIndentation, boolean excludeFirstLine) {
        if (numberIndentation == 0) {
            return content;
        }
        if (content.contains("\n")) {
            String indentation = StringUtils.repeat((String)" ", (int)numberIndentation);
            Scanner scanner = new Scanner(content);
            StringBuilder buffer = new StringBuilder();
            if (!excludeFirstLine) {
                buffer.append(indentation);
            }
            buffer.append(scanner.nextLine());
            buffer.append("\n");
            while (scanner.hasNextLine()) {
                buffer.append(indentation);
                buffer.append(scanner.nextLine());
                buffer.append("\n");
            }
            scanner.close();
            return buffer.toString();
        }
        return content;
    }

    private void removeAnnotations(ISourceViewer viewer) {
        if (viewer != null) {
            for (Annotation annotation : this.annotations) {
                viewer.getAnnotationModel().removeAnnotation(annotation);
            }
            this.annotations.clear();
        }
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        throw new UnsupportedOperationException("apply(document, trigger, offset) should not be called anymore from TemplateCompletionProposal");
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.updater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    TemplateCompletionProposal.this.ensurePositionCategoryRemoved(document);
                    TemplateCompletionProposal.this.removeAnnotations(TemplateCompletionProposal.this.sourceViewer);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater((IPositionUpdater)this.updater);
        }
    }

    private String getCategory() {
        return "miworkplace.template.proposal.category";
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.selectedRegion == null) {
            return new Point(this.cursorPosition + this.replacementString.length(), 0);
        }
        return new Point(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
    }

    public boolean containsWordSelection() {
        return this.template.getCode().contains("${word_selection}");
    }

    public boolean containsLineSelection() {
        return this.template.getCode().contains("${line_selection}");
    }

    private int determineTemplateLineSelectionIndentation() {
        String code = this.template.getCode();
        int x = code.indexOf("${line_selection}");
        if (x == -1) {
            return -1;
        }
        int i = x;
        while (i >= 0) {
            if (code.charAt(i) == '\n') {
                return x - i - 1;
            }
            --i;
        }
        return x;
    }
}

