/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.util.ArrayList;
import miworkplace.ui.editor.TemplateParser;
import miworkplace.ui.editor.TemplateVariable;

public class TemplateBuffer {
    private String content;
    private final TemplateVariable[] variables;
    private TemplateVariable cursorVariable;

    public TemplateBuffer(String content) throws Exception {
        this.content = content;
        TemplateParser parser = new TemplateParser();
        TemplateVariable[] templateVariableArray = this.variables = parser.parse(content);
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable v = templateVariableArray[n2];
            if (v.getName().equals("cursor")) {
                this.cursorVariable = v;
                break;
            }
            ++n2;
        }
    }

    public TemplateBuffer(String content, TemplateVariable cursorVariable) throws Exception {
        this(content);
        this.cursorVariable = cursorVariable;
    }

    public String getContent() {
        return this.content;
    }

    public TemplateVariable[] getVariables() {
        return this.variables;
    }

    public TemplateVariable[] getUnresolvedVariables() {
        ArrayList<TemplateVariable> unresolved = new ArrayList<TemplateVariable>();
        TemplateVariable[] templateVariableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            if (!variable.isResolved()) {
                unresolved.add(variable);
            }
            ++n2;
        }
        return unresolved.toArray(new TemplateVariable[unresolved.size()]);
    }

    public TemplateVariable getCursorVariable() {
        return this.cursorVariable;
    }

    public String toString() {
        return this.content;
    }
}

