/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ILEDocsCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension4,
ICompletionProposalExtension6 {
    protected final String tag;
    private static ImageRegistry imageRegistry;
    private int newSelectedOffset = -1;

    public ILEDocsCompletionProposal(String tag) {
        this.tag = tag;
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            Image image = new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/iledocs.gif"));
            imageRegistry.put("iledocs", image);
        }
    }

    public void apply(IDocument document) {
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.tag;
    }

    public Image getImage() {
        return imageRegistry.get("iledocs");
    }

    public Point getSelection(IDocument document) {
        if (this.newSelectedOffset == -1) {
            return null;
        }
        return new Point(this.newSelectedOffset, 0);
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public void apply(IDocument document, char trigger, int offset) {
        String currentValue = this.computeCurrentValue(document, offset);
        if (currentValue != null) {
            try {
                document.replace(offset - currentValue.length(), currentValue.length(), this.tag + " ");
                this.newSelectedOffset = offset - currentValue.length() + this.tag.length() + 1;
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public int getContextInformationPosition() {
        return -1;
    }

    public char[] getTriggerCharacters() {
        return new char[0];
    }

    public boolean isValidFor(IDocument document, int offset) {
        String currentValue = this.computeCurrentValue(document, offset);
        return currentValue == null ? true : this.tag.startsWith(currentValue);
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.tag);
    }

    protected String computeCurrentValue(IDocument document, int offset) {
        String currentValue = null;
        try {
            int lineNumber = document.getLineOfOffset(offset);
            int lineOffset = document.getLineOffset(lineNumber);
            String line = document.get(lineOffset, offset - lineOffset);
            int lineLength = line.length();
            int i = lineLength - 1;
            while (i >= 0) {
                char c = line.charAt(i);
                switch (c) {
                    case ' ': 
                    case '*': {
                        int valueOffset = i + 1;
                        return lineLength > valueOffset ? line.substring(valueOffset) : "";
                    }
                }
                --i;
            }
            if (lineOffset == offset - line.length()) {
                return line;
            }
        }
        catch (BadLocationException badLocationException) {}
        return currentValue;
    }
}

