/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import miworkplace.ui.editor.Activator;
import miworkplace.ui.editor.ColoredStyler;
import miworkplace.ui.editor.CompletionProposalComparator;
import miworkplace.ui.editor.ILEDocsCompletionProposal;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.TemplateCompletionProposal;
import miworkplace.ui.editor.TemplateContext;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ILEDocsCompletionProcessor
implements IContentAssistProcessor {
    private static final String ILEDOCS_TAG_PREFIX = "miworkplace.iledocs.pref.prefix";
    @Inject
    private ITemplateService templateService;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private TemplateContext templateContext;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    private Image image;
    private StyledString.Styler stylerName;
    private StyledString.Styler stylerDescription;
    private ILEDocsCompletionProposal[] tagsProposals;
    private String iledocsPrefix;

    @PostConstruct
    private void postConstruct() {
        this.iledocsPrefix = this.applicationPreferences.get(ILEDOCS_TAG_PREFIX, "@");
        this.tagsProposals = this.buildProposals();
        this.image = this.imagePool.getImageUnchecked("IMAGE_TEMPLATE");
        this.stylerName = new ColoredStyler(this.imagePool.getColorUnchecked("COLOR_CONTENT_ASSIST_TEMPLATE"));
        this.stylerDescription = new ColoredStyler(this.imagePool.getColorUnchecked("COLOR_CONTENT_ASSIST_DESCRIPTION"));
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<Object> tempProposals = new ArrayList<Object>();
        ILEDocsCompletionProposal[] iLEDocsCompletionProposalArray = this.tagsProposals;
        int n = this.tagsProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ILEDocsCompletionProposal proposal = iLEDocsCompletionProposalArray[n2];
            if (proposal.isValidFor(viewer.getDocument(), offset)) {
                tempProposals.add(proposal);
            }
            ++n2;
        }
        for (Template template : this.templateService.get()) {
            TemplateCompletionProposal proposal;
            if (!template.getContext().equals("ILEDocs") || !(proposal = new TemplateCompletionProposal(template, this.image, this.stylerName, this.stylerDescription, this.templateContext)).isValidFor(viewer.getDocument(), offset)) continue;
            tempProposals.add(proposal);
        }
        Collections.sort(tempProposals, new CompletionProposalComparator());
        return tempProposals.toArray(new ICompletionProposal[tempProposals.size()]);
    }

    private ILEDocsCompletionProposal[] buildProposals() {
        String[] tags;
        ArrayList<ILEDocsCompletionProposal> proposals = new ArrayList<ILEDocsCompletionProposal>();
        PreferenceStore properties = Activator.getDefault().getSyntaxHighlightingPreferenceStore();
        String[] stringArray = tags = properties.getString("miworkplace.ui.editor.iledocs.tags").split(",");
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            String fullTagName = this.iledocsPrefix + tag.trim();
            proposals.add(new ILEDocsCompletionProposal(fullTagName));
            ++n2;
        }
        Collections.sort(proposals, new CompletionProposalComparator());
        return proposals.toArray(new ILEDocsCompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

