/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import miworkplace.common.debug.Debug;
import miworkplace.ui.editor.DocumentBoundaryFinder;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class DoubleClickStrategy
implements ITextDoubleClickStrategy {
    private Debug logger = Debug.getInstance();
    private DocumentBoundaryFinder boundaryFinder;

    @Inject
    public DoubleClickStrategy(DocumentBoundaryFinder boundaryFinder) {
        this.boundaryFinder = boundaryFinder;
    }

    public void doubleClicked(ITextViewer viewer) {
        try {
            Region boundary = this.boundaryFinder.findBoundary(viewer);
            if (boundary != null) {
                viewer.setSelectedRange(boundary.getOffset(), boundary.getLength());
            }
        }
        catch (Exception e) {
            this.logger.error(MessageFormat.format("Could not find word boundary for selected text range {0}", viewer.getSelectedRange().x), (Throwable)e);
        }
    }
}

