/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import jakarta.inject.Inject;
import miworkplace.ui.editor.WordBoundaryFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class DocumentBoundaryFinder {
    private WordBoundaryFinder boundaryFinder;

    @Inject
    public DocumentBoundaryFinder(WordBoundaryFinder bounderyFinder) {
        this.boundaryFinder = bounderyFinder;
    }

    public Region findBoundary(ITextViewer viewer) throws Exception {
        IDocument document = viewer.getDocument();
        int offset = viewer.getSelectedRange().x;
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        Region boundary = this.boundaryFinder.findBoundary(line, offset - lineInfo.getOffset());
        return new Region(lineInfo.getOffset() + boundary.getOffset(), boundary.getLength());
    }
}

