/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.ui.editor.AbstractCompletionProposal;
import miworkplace.ui.editor.ColoredStyler;
import miworkplace.ui.editor.CompletionProposalComparator;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;
import miworkplace.ui.editor.TemplateCompletionProposal;
import miworkplace.ui.editor.TemplateContext;
import miworkplace.ui.themes.Colors;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.osgi.service.event.Event;

public class DefaultCompletionProcessor
implements IContentAssistProcessor {
    @Inject
    private ITemplateService templateService;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private TemplateContext templateContext;
    private Image image;
    private StyledString.Styler stylerName;
    private StyledString.Styler stylerDescription;
    private List<AbstractCompletionProposal> proposals = new ArrayList<AbstractCompletionProposal>();

    @PostConstruct
    private void postConstruct() {
        this.image = this.imagePool.getImageUnchecked("IMAGE_TEMPLATE");
        this.stylerName = new ColoredStyler(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
        this.stylerDescription = new ColoredStyler(Colors.instance().get(Colors.ColorDefinition.Comment));
        this.loadTemplates();
    }

    private void loadTemplates() {
        for (Template template : this.templateService.get()) {
            if (!template.getContext().equals("Other")) continue;
            TemplateCompletionProposal proposal = new TemplateCompletionProposal(template, this.image, this.stylerName, this.stylerDescription, this.templateContext);
            this.proposals.add(proposal);
        }
    }

    @Inject
    @Optional
    public void notifiedTemplatesPersisted(@UIEventTopic(value="miworkplace/ui/editor/template/persisted") Event event) {
        this.proposals.clear();
        this.loadTemplates();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<AbstractCompletionProposal> filteredProposals = new ArrayList<AbstractCompletionProposal>();
        for (AbstractCompletionProposal proposal : this.proposals) {
            if (!proposal.isValidFor(viewer.getDocument(), offset)) continue;
            filteredProposals.add(proposal);
        }
        Collections.sort(filteredProposals, new CompletionProposalComparator());
        return filteredProposals.toArray(new ICompletionProposal[filteredProposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

