/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import miworkplace.common.debug.Debug;
import miworkplace.ui.api.Position;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;

public class CursorPositionChangedListener
implements KeyListener,
MouseListener {
    protected IEventBroker eventBroker;
    protected ITextViewer viewer;
    protected Debug logger = Debug.getInstance();

    public CursorPositionChangedListener(IEventBroker eventBroker, ITextViewer viewer) {
        this.eventBroker = eventBroker;
        this.viewer = viewer;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.sendPositionUpdate();
    }

    public void mouseUp(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        this.sendPositionUpdate();
    }

    public void keyReleased(KeyEvent e) {
    }

    protected Position getCurrentPosition() {
        Point selection = this.viewer.getSelectedRange();
        if (selection != null) {
            int x = selection.x;
            try {
                int line = this.viewer.getDocument().getLineOfOffset(x);
                IRegion lineInformation = this.viewer.getDocument().getLineInformation(line);
                int column = x - lineInformation.getOffset();
                return new Position(line + 1, column + 1);
            }
            catch (Exception e) {
                this.logger.error("Could not determine current cursor position.", (Throwable)e);
            }
        }
        return null;
    }

    public void sendPositionUpdate() {
        Position position = this.getCurrentPosition();
        if (position != null) {
            this.eventBroker.post("miworkplace/ui/editor/position/changed", (Object)position);
        }
    }
}

