/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.ddm;

import com.ibm.jtopenlite.ddm.DDMCallbackEvent;
import com.ibm.jtopenlite.ddm.DDMDataBuffer;

public final class DDMFile {
    public static final int READ_ONLY = 0;
    public static final int WRITE_ONLY = 1;
    public static final int READ_WRITE = 2;
    private final String library_;
    private final String file_;
    private final String member_;
    private final byte[] recordFormatName_;
    private final byte[] dclNam_;
    private final int openType_;
    private final int recordLength_;
    private final int recordIncrement_;
    private final int batchSize_;
    private final int nullFieldByteMapOffset_;
    private final DDMDataBuffer[] buffers_;
    private final DDMCallbackEvent eventBuffer_;
    private int bufferIndex_;

    DDMFile(String string, String string2, String string3, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.library_ = string;
        this.file_ = string2;
        this.member_ = string3;
        this.recordFormatName_ = byArray;
        this.dclNam_ = byArray2;
        this.openType_ = n;
        this.recordLength_ = n2;
        this.recordIncrement_ = n3;
        this.batchSize_ = n4;
        this.nullFieldByteMapOffset_ = n5;
        this.eventBuffer_ = new DDMCallbackEvent(this);
        n6 = n6 <= 0 ? 1 : n6;
        this.buffers_ = new DDMDataBuffer[n6];
        for (int i = 0; i < n6; ++i) {
            this.buffers_[i] = new DDMDataBuffer(this.recordLength_, this.recordIncrement_ - this.recordLength_ + 2, this.recordIncrement_ - n5);
        }
    }

    byte[] getDCLNAM() {
        return this.dclNam_;
    }

    byte[] getRecordFormatName() {
        return this.recordFormatName_;
    }

    int getRecordIncrement() {
        return this.recordIncrement_;
    }

    int getBatchSize() {
        return this.batchSize_;
    }

    int getNullFieldByteMapOffset() {
        return this.nullFieldByteMapOffset_;
    }

    void nextBuffer() {
        if (++this.bufferIndex_ == this.buffers_.length) {
            this.bufferIndex_ = 0;
        }
    }

    public int getBufferCount() {
        return this.buffers_.length;
    }

    int getCurrentBufferIndex() {
        return this.bufferIndex_;
    }

    DDMDataBuffer getDataBuffer(int n) {
        return this.buffers_[n];
    }

    DDMDataBuffer getNextDataBuffer() {
        int n = this.bufferIndex_ + 1;
        if (n == this.buffers_.length) {
            n = 0;
        }
        return this.buffers_[n];
    }

    byte[] getNullFieldMap() {
        return this.buffers_[this.bufferIndex_].getNullFieldMap();
    }

    boolean[] getNullFieldValues() {
        return this.buffers_[this.bufferIndex_].getNullFieldValues();
    }

    public int getRecordLength() {
        return this.recordLength_;
    }

    public byte[] getRecordDataBuffer() {
        return this.buffers_[this.bufferIndex_].getRecordDataBuffer();
    }

    byte[] getPacketBuffer() {
        return this.buffers_[this.bufferIndex_].getPacketBuffer();
    }

    DDMCallbackEvent getEventBuffer() {
        return this.eventBuffer_;
    }

    public int getReadWriteType() {
        return this.openType_;
    }

    public String getLibrary() {
        return this.library_;
    }

    public String getFile() {
        return this.file_;
    }

    public String getMember() {
        return this.member_;
    }

    public String toString() {
        return this.library_ + this.file_ + this.member_;
    }
}

