/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.database.DatabaseConnection;
import com.ibm.jtopenlite.database.DatabaseOpenAndDescribeAttributes;
import com.ibm.jtopenlite.database.DatabaseRequestAttributes;
import com.ibm.jtopenlite.database.DatabaseSQLCommunicationsAreaCallback;
import com.ibm.jtopenlite.database.jdbc.JDBCConnection;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import com.ibm.jtopenlite.database.jdbc.JDBCResultSet;
import com.ibm.jtopenlite.database.jdbc.JDBCResultSetMetaData;
import com.ibm.jtopenlite.database.jdbc.NotImplementedException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class JDBCStatement
implements Statement,
DatabaseSQLCommunicationsAreaCallback {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_INSERT_UPDATE_DELETE = 1;
    public static final int TYPE_SELECT = 2;
    public static final int TYPE_CALL = 3;
    public static final int TYPE_COMMIT = 4;
    public static final int TYPE_ROLLBACK = 5;
    public static final int TYPE_CONNECT = 6;
    public static final int TYPE_BLOCKED_INSERT = 7;
    JDBCConnection conn_;
    DatabaseRequestAttributes statementAttributes_;
    DatabaseRequestAttributes attribs_;
    int rpbID_;
    int fetchSize_;
    String cursorName_ = null;
    JDBCResultSet currentResultSet_;
    boolean closed_;
    String generatedKey_;
    int updateCount_ = -1;
    int lastUpdateCount_ = -1;
    int resultSetsCount_ = -1;
    int lastSQLCode_;
    String lastSQLState_;
    String statementName_ = null;
    String catalog_ = null;
    boolean poolable_ = false;

    public static int getStatementType(String string) throws SQLException {
        int n;
        if (string == null) {
            JDBCError.throwSQLException("42601");
        }
        String string2 = string.toUpperCase().trim();
        while (string2.length() > 0 && string2.charAt(0) == '(') {
            string2 = string2.substring(1).trim();
        }
        int n2 = string2.startsWith("SELECT") || string2.startsWith("VALUES") ? 2 : (string2.startsWith("INSERT") || string2.startsWith("UPDATE") || string2.startsWith("DELETE") ? 1 : (string2.startsWith("CALL") ? 3 : (string2.startsWith("COMMIT") ? 4 : (string2.startsWith("ROLLBACK") ? 5 : (string2.startsWith("CONNECT") || string2.startsWith("SET") || string2.startsWith("RELEASE") || string2.startsWith("DISCONNECT") ? 6 : (n = string2.startsWith("BLOCKED INSERT") ? 7 : 0))))));
        if (string2.length() > 0x100000) {
            JDBCError.throwSQLException("54001");
        }
        return n;
    }

    public JDBCStatement(JDBCConnection jDBCConnection, String string, String string2, int n) throws SQLException {
        this.cursorName_ = string2;
        this.statementName_ = string;
        if (n != 0) {
            DatabaseRequestAttributes databaseRequestAttributes = new DatabaseRequestAttributes();
            databaseRequestAttributes.setCursorName(string2);
            databaseRequestAttributes.setPrepareStatementName(string);
            jDBCConnection.createRequestParameterBlock(databaseRequestAttributes, n);
            this.attribs_ = databaseRequestAttributes;
            this.statementAttributes_ = databaseRequestAttributes.copy();
        }
        this.conn_ = jDBCConnection;
        this.rpbID_ = n;
    }

    public void newSQLCommunicationsAreaData(int n, String string, String string2, int n2, int n3) {
        this.generatedKey_ = n == 0 ? string2 : null;
        this.lastUpdateCount_ = n2;
        this.lastSQLCode_ = n;
        this.lastSQLState_ = string;
        this.resultSetsCount_ = n3;
    }

    int getLastSQLCode() {
        return this.lastSQLCode_;
    }

    String getLastSQLState() {
        return this.lastSQLState_;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.conn_.getDatabaseConnection();
    }

    DatabaseRequestAttributes getRequestAttributes() {
        this.attribs_.clear();
        return this.attribs_;
    }

    public void addBatch(String string) throws SQLException {
        throw new NotImplementedException();
    }

    public void cancel() throws SQLException {
        throw new NotImplementedException();
    }

    public void clearBatch() throws SQLException {
        throw new NotImplementedException();
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        if (this.closed_) {
            return;
        }
        try {
            this.generatedKey_ = null;
            if (this.currentResultSet_ != null) {
                this.currentResultSet_.close();
                this.currentResultSet_ = null;
            }
            this.attribs_.clear();
            this.conn_.getDatabaseConnection().deleteRequestParameterBlock(this.attribs_, this.rpbID_);
            this.conn_.freeRPBID(this.rpbID_);
            if (this.statementName_ != null) {
                this.conn_.freeStatementAndCursorNames(this.statementName_, this.cursorName_);
            }
            this.statementName_ = null;
            this.cursorName_ = null;
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
        }
        finally {
            this.closed_ = true;
        }
    }

    public boolean execute(String string) throws SQLException {
        return this.execute(string, 2);
    }

    public boolean execute(String string, int n) throws SQLException {
        boolean bl;
        block12: {
            int n2;
            if (this.closed_) {
                JDBCError.throwSQLException("HY010");
            }
            if (this.currentResultSet_ != null) {
                this.currentResultSet_.close();
                this.currentResultSet_ = null;
            }
            if ((n2 = JDBCStatement.getStatementType(string)) == 2) {
                this.currentResultSet_ = (JDBCResultSet)this.executeQuery(string);
                return true;
            }
            DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
            databaseConnection.setSQLCommunicationsAreaCallback(this);
            DatabaseRequestAttributes databaseRequestAttributes = this.getRequestAttributes();
            databaseRequestAttributes.setSQLStatementText(string);
            if (n2 == 3) {
                databaseRequestAttributes.setSQLStatementType(3);
                databaseRequestAttributes.setOpenAttributes(128);
                databaseRequestAttributes.setPrepareOption(0);
            }
            bl = false;
            try {
                databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
                this.generatedKey_ = null;
                databaseConnection.executeImmediate(databaseRequestAttributes);
                this.updateCount_ = this.lastUpdateCount_;
                if (this.resultSetsCount_ <= 0) break block12;
                bl = true;
                DatabaseRequestAttributes databaseRequestAttributes2 = this.getRequestAttributes();
                databaseRequestAttributes2.setOpenAttributes(128);
                databaseRequestAttributes2.setScrollableCursorFlag(0);
                databaseRequestAttributes2.setVariableFieldCompression(232);
                if (this.catalog_ == null) {
                    this.catalog_ = this.conn_.getCatalog();
                }
                JDBCResultSetMetaData jDBCResultSetMetaData = new JDBCResultSetMetaData(databaseConnection.getInfo().getServerCCSID(), this.conn_.getCalendar(), this.catalog_);
                try {
                    databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
                    if (this.currentResultSet_ != null) {
                        this.currentResultSet_.close();
                        this.currentResultSet_ = null;
                    }
                    databaseConnection.openAndDescribe(databaseRequestAttributes2, jDBCResultSetMetaData);
                }
                catch (IOException iOException) {
                    throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
                }
                this.currentResultSet_ = new JDBCResultSet(this, jDBCResultSetMetaData, this.statementName_, this.cursorName_, this.fetchSize_);
                this.updateCount_ = -1;
            }
            catch (IOException iOException) {
                throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
            }
        }
        return bl;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new NotImplementedException();
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new NotImplementedException();
    }

    public int[] executeBatch() throws SQLException {
        throw new NotImplementedException();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.currentResultSet_ != null) {
            this.currentResultSet_.close();
            this.currentResultSet_ = null;
        }
        if (this.catalog_ == null) {
            this.catalog_ = this.conn_.getCatalog();
        }
        DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
        databaseConnection.setSQLCommunicationsAreaCallback(this);
        DatabaseRequestAttributes databaseRequestAttributes = this.getRequestAttributes();
        databaseRequestAttributes.setExtendedSQLStatementText(string);
        int n = JDBCStatement.getStatementType(string);
        switch (n) {
            case 2: {
                databaseRequestAttributes.setOpenAttributes(128);
                databaseRequestAttributes.setExtendedColumnDescriptorOption(241);
            }
            case 3: {
                break;
            }
            default: {
                throw new SQLException("Not a query");
            }
        }
        databaseRequestAttributes.setSQLStatementType(n);
        try {
            databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
            this.generatedKey_ = null;
            JDBCResultSetMetaData jDBCResultSetMetaData = new JDBCResultSetMetaData(databaseConnection.getInfo().getServerCCSID(), this.conn_.getCalendar(), this.catalog_);
            databaseConnection.prepareAndDescribe(databaseRequestAttributes, jDBCResultSetMetaData, null);
            if (n == 2) {
                DatabaseOpenAndDescribeAttributes databaseOpenAndDescribeAttributes = databaseRequestAttributes;
                if (this.fetchSize_ > 0) {
                    databaseOpenAndDescribeAttributes.setBlockingFactor(this.fetchSize_);
                }
                databaseOpenAndDescribeAttributes.setDescribeOption(213);
                databaseOpenAndDescribeAttributes.setScrollableCursorFlag(0);
                databaseOpenAndDescribeAttributes.setVariableFieldCompression(232);
                databaseConnection.openAndDescribe(databaseOpenAndDescribeAttributes, null);
                this.currentResultSet_ = new JDBCResultSet(this, jDBCResultSetMetaData, this.statementName_, this.cursorName_, this.fetchSize_);
                this.updateCount_ = -1;
                return this.currentResultSet_;
            }
            DatabaseRequestAttributes databaseRequestAttributes2 = this.getRequestAttributes();
            ((DatabaseOpenAndDescribeAttributes)databaseRequestAttributes2).setScrollableCursorFlag(0);
            ((DatabaseOpenAndDescribeAttributes)databaseRequestAttributes2).setResultSetHoldabilityOption(232);
            ((DatabaseOpenAndDescribeAttributes)databaseRequestAttributes2).setVariableFieldCompression(232);
            if (this.fetchSize_ > 0) {
                ((DatabaseOpenAndDescribeAttributes)databaseRequestAttributes2).setBlockingFactor(this.fetchSize_);
            }
            databaseRequestAttributes2.setSQLStatementType(3);
            databaseConnection.execute(databaseRequestAttributes2);
            if (this.resultSetsCount_ > 0) {
                DatabaseRequestAttributes databaseRequestAttributes3 = this.getRequestAttributes();
                databaseRequestAttributes3.setOpenAttributes(128);
                databaseRequestAttributes3.setScrollableCursorFlag(0);
                databaseRequestAttributes3.setVariableFieldCompression(232);
                if (this.catalog_ == null) {
                    this.catalog_ = this.conn_.getCatalog();
                }
                jDBCResultSetMetaData = new JDBCResultSetMetaData(databaseConnection.getInfo().getServerCCSID(), this.conn_.getCalendar(), this.catalog_);
                databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
                if (this.currentResultSet_ != null) {
                    this.currentResultSet_.close();
                    this.currentResultSet_ = null;
                }
                databaseConnection.openAndDescribe(databaseRequestAttributes3, jDBCResultSetMetaData);
                this.currentResultSet_ = new JDBCResultSet(this, jDBCResultSetMetaData, this.statementName_, this.cursorName_, this.fetchSize_);
                this.updateCount_ = -1;
                return this.currentResultSet_;
            }
            JDBCError.throwSQLException("HY010");
            return null;
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
        }
    }

    public int executeUpdate(String string) throws SQLException {
        return this.executeUpdate(string, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.currentResultSet_ != null) {
            this.currentResultSet_.close();
            this.currentResultSet_ = null;
        }
        JDBCStatement.getStatementType(string);
        DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
        databaseConnection.setSQLCommunicationsAreaCallback(this);
        DatabaseRequestAttributes databaseRequestAttributes = this.getRequestAttributes();
        databaseRequestAttributes.setExtendedSQLStatementText(string);
        databaseRequestAttributes.setOpenAttributes(128);
        databaseRequestAttributes.setDescribeOption(213);
        databaseRequestAttributes.setScrollableCursorFlag(0);
        try {
            databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
            this.generatedKey_ = null;
            this.updateCount_ = 0;
            databaseConnection.setSQLCommunicationsAreaCallback(this);
            databaseConnection.prepareAndExecute(databaseRequestAttributes, null);
            this.updateCount_ = this.lastUpdateCount_;
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
        }
        return this.updateCount_;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new NotImplementedException();
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new NotImplementedException();
    }

    public Connection getConnection() throws SQLException {
        return this.conn_;
    }

    public int getFetchDirection() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.fetchSize_;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.generatedKey_ != null) {
            if (this.catalog_ == null) {
                this.catalog_ = this.conn_.getCatalog();
            }
            JDBCResultSetMetaData jDBCResultSetMetaData = new JDBCResultSetMetaData(37, this.conn_.getCalendar(), this.catalog_);
            jDBCResultSetMetaData.resultSetDescription(1, 0, 0, 0, 0, 8);
            jDBCResultSetMetaData.fieldDescription(0, 492, 8, 0, 0, 0, 0, 0, 0);
            jDBCResultSetMetaData.fieldName(0, "GENERATED_KEY");
            JDBCResultSet jDBCResultSet = new JDBCResultSet(this, jDBCResultSetMetaData, null, null, 0);
            jDBCResultSet.newResultData(1, 1, 8);
            jDBCResultSet.newRowData(0, Conv.longToByteArray(new Long(this.generatedKey_)));
            return jDBCResultSet;
        }
        return null;
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 0;
    }

    public int getMaxRows() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        throw new NotImplementedException();
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new NotImplementedException();
    }

    public int getQueryTimeout() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.currentResultSet_;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 1;
    }

    public int getResultSetType() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.updateCount_;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return null;
    }

    public void setCursorName(String string) throws SQLException {
        throw new NotImplementedException();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new NotImplementedException();
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new NotImplementedException();
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (n < 0) {
            throw new SQLException("Bad value for fetch size: " + n);
        }
        this.fetchSize_ = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new NotImplementedException();
    }

    public void setMaxRows(int n) throws SQLException {
        throw new NotImplementedException();
    }

    public void setQueryTimeout(int n) throws SQLException {
        throw new NotImplementedException();
    }

    public boolean isClosed() {
        return this.closed_;
    }

    protected void setCursorNameInternal(String string) {
        this.cursorName_ = string;
    }

    public boolean isPoolable() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.poolable_;
    }

    public void setPoolable(boolean bl) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        this.poolable_ = bl;
    }

    public void setCatalog(String string) {
        this.catalog_ = string;
    }
}

