/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.database.DatabaseConnection;
import com.ibm.jtopenlite.database.DatabaseDescribeCallback;
import com.ibm.jtopenlite.database.DatabaseOpenAndDescribeAttributes;
import com.ibm.jtopenlite.database.DatabaseRequestAttributes;
import com.ibm.jtopenlite.database.jdbc.Column;
import com.ibm.jtopenlite.database.jdbc.JDBCConnection;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import com.ibm.jtopenlite.database.jdbc.JDBCParameterMetaData;
import com.ibm.jtopenlite.database.jdbc.JDBCResultSet;
import com.ibm.jtopenlite.database.jdbc.JDBCResultSetMetaData;
import com.ibm.jtopenlite.database.jdbc.JDBCStatement;
import com.ibm.jtopenlite.database.jdbc.NotImplementedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class JDBCPreparedStatement
extends JDBCStatement
implements PreparedStatement {
    private JDBCParameterMetaData pmd_;
    private int descriptorHandle_;
    private boolean returnGeneratedKeys_;
    private int sqlStatementType_;
    private JDBCResultSetMetaData rsmd_;

    public JDBCPreparedStatement(JDBCConnection jDBCConnection, String string, Calendar calendar, String string2, String string3, int n) throws SQLException {
        super(jDBCConnection, string2, string3, n);
        this.poolable_ = true;
        if (string == null) {
            JDBCError.throwSQLException("42601");
            return;
        }
        this.rsmd_ = null;
        DatabaseRequestAttributes databaseRequestAttributes = new DatabaseRequestAttributes();
        this.sqlStatementType_ = JDBCStatement.getStatementType(string);
        this.statementAttributes_.setSQLStatementType(this.sqlStatementType_);
        databaseRequestAttributes.setSQLStatementType(this.sqlStatementType_);
        databaseRequestAttributes.setPrepareOption(0);
        if (this.sqlStatementType_ == 2) {
            databaseRequestAttributes.setOpenAttributes(128);
        }
        JDBCParameterMetaData jDBCParameterMetaData = new JDBCParameterMetaData(calendar);
        String string4 = this.conn_.getCatalog();
        DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
        databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
        this.rsmd_ = new JDBCResultSetMetaData(jDBCConnection.getDatabaseInfo().getServerCCSID(), calendar, string4);
        databaseRequestAttributes.setExtendedSQLStatementText(string);
        jDBCConnection.prepareAndDescribe(databaseRequestAttributes, this.rsmd_, jDBCParameterMetaData);
        int n2 = -1;
        DatabaseRequestAttributes databaseRequestAttributes2 = databaseRequestAttributes;
        byte[] byArray = jDBCParameterMetaData.getExtendedSQLParameterMarkerDataFormat();
        databaseRequestAttributes2.setExtendedSQLParameterMarkerDataFormat(byArray);
        int n3 = n2 = byArray == null ? -1 : jDBCConnection.getNextDescriptorHandle();
        if (n2 >= 0) {
            jDBCConnection.changeDescriptor(databaseRequestAttributes2, n2);
        }
        this.pmd_ = jDBCParameterMetaData;
        this.pmd_.setStatement(this);
        this.descriptorHandle_ = n2;
    }

    void setReturnGeneratedKeys(boolean bl) {
        this.returnGeneratedKeys_ = bl;
    }

    public void addBatch() throws SQLException {
        throw new NotImplementedException();
    }

    public void clearParameters() throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        for (int i = 0; i < this.pmd_.getParameterCount(); ++i) {
            Column column = this.pmd_.getColumn(i);
            column.clearValue();
        }
    }

    public boolean execute() throws SQLException {
        block16: {
            Object object;
            boolean bl = false;
            if (this.closed_) {
                throw JDBCError.getSQLException("HY010");
            }
            if (this.sqlStatementType_ == 2) {
                this.executeQuery();
                return true;
            }
            DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
            databaseConnection.setSQLCommunicationsAreaCallback(this);
            DatabaseRequestAttributes databaseRequestAttributes = this.getRequestAttributes();
            ((DatabaseOpenAndDescribeAttributes)databaseRequestAttributes).setScrollableCursorFlag(0);
            ((DatabaseOpenAndDescribeAttributes)databaseRequestAttributes).setResultSetHoldabilityOption(232);
            ((DatabaseOpenAndDescribeAttributes)databaseRequestAttributes).setVariableFieldCompression(232);
            if (this.statementAttributes_.getSQLStatementType() == 3) {
                databaseRequestAttributes.setSQLStatementType(3);
                bl = true;
            }
            if (this.pmd_.getParameterCount() > 0) {
                object = this.getExtendedParameterMarkerData();
                databaseRequestAttributes.setSQLExtendedParameterMarkerData((byte[])object);
            }
            try {
                databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
                if (this.currentResultSet_ != null) {
                    this.currentResultSet_.close();
                    this.currentResultSet_ = null;
                }
                this.updateCount_ = 0;
                if (this.descriptorHandle_ < 0) {
                    databaseConnection.execute(databaseRequestAttributes);
                } else {
                    databaseConnection.execute(databaseRequestAttributes, this.descriptorHandle_);
                }
                this.updateCount_ = this.lastUpdateCount_;
                if (!bl || this.resultSetsCount_ <= 0) break block16;
                object = this.getRequestAttributes();
                object.setOpenAttributes(128);
                object.setScrollableCursorFlag(0);
                object.setVariableFieldCompression(232);
                JDBCResultSetMetaData jDBCResultSetMetaData = new JDBCResultSetMetaData(databaseConnection.getInfo().getServerCCSID(), this.conn_.getCalendar(), this.conn_.getCatalog());
                try {
                    databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
                    if (this.currentResultSet_ != null) {
                        this.currentResultSet_.close();
                        this.currentResultSet_ = null;
                    }
                    if (this.descriptorHandle_ < 0) {
                        databaseConnection.openAndDescribe((DatabaseOpenAndDescribeAttributes)object, jDBCResultSetMetaData);
                    } else {
                        databaseConnection.openAndDescribe((DatabaseOpenAndDescribeAttributes)object, this.descriptorHandle_, jDBCResultSetMetaData);
                    }
                }
                catch (IOException iOException) {
                    throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
                }
                this.currentResultSet_ = new JDBCResultSet(this, jDBCResultSetMetaData, this.statementName_, this.cursorName_, this.fetchSize_);
                this.updateCount_ = -1;
            }
            catch (IOException iOException) {
                throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
            }
        }
        return true;
    }

    public ResultSet executeQuery() throws SQLException {
        Object object;
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        switch (this.sqlStatementType_) {
            case 2: {
                break;
            }
            case 3: {
                boolean bl = this.execute();
                if (bl) {
                    ResultSet resultSet = this.getResultSet();
                    if (resultSet == null) {
                        throw JDBCError.getSQLException("24000");
                    }
                    return resultSet;
                }
                throw JDBCError.getSQLException("24000");
            }
            default: {
                throw JDBCError.getSQLException("24000");
            }
        }
        if (this.currentResultSet_ != null) {
            this.currentResultSet_.close();
            this.currentResultSet_ = null;
        }
        DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
        databaseConnection.setSQLCommunicationsAreaCallback(this);
        DatabaseRequestAttributes databaseRequestAttributes = this.getRequestAttributes();
        databaseRequestAttributes.setPrepareStatementName(this.statementName_);
        if (this.cursorName_ == null) {
            this.cursorName_ = this.conn_.getNextCursorName();
        }
        databaseRequestAttributes.setCursorName(this.cursorName_);
        if (this.fetchSize_ > 0) {
            databaseRequestAttributes.setBlockingFactor(this.fetchSize_);
        }
        databaseRequestAttributes.setDescribeOption(213);
        databaseRequestAttributes.setScrollableCursorFlag(0);
        databaseRequestAttributes.setVariableFieldCompression(232);
        if (this.descriptorHandle_ >= 0) {
            object = this.getExtendedParameterMarkerData();
            databaseRequestAttributes.setSQLExtendedParameterMarkerData((byte[])object);
        }
        object = new JDBCResultSetMetaData(databaseConnection.getInfo().getServerCCSID(), this.conn_.getCalendar(), this.conn_.getCatalog());
        try {
            databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
            if (this.descriptorHandle_ < 0) {
                databaseConnection.openAndDescribe(databaseRequestAttributes, (DatabaseDescribeCallback)object);
            } else {
                databaseConnection.openAndDescribe(databaseRequestAttributes, this.descriptorHandle_, (DatabaseDescribeCallback)object);
            }
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
        }
        this.currentResultSet_ = new JDBCResultSet(this, (JDBCResultSetMetaData)object, this.statementName_, this.cursorName_, this.fetchSize_);
        return this.currentResultSet_;
    }

    private byte[] getExtendedParameterMarkerData() throws SQLException {
        int n = this.pmd_.getParameterCount();
        int n2 = 20 + n * 2 + this.pmd_.getRowSize();
        byte[] byArray = new byte[n2];
        Conv.intToByteArray(1, byArray, 0);
        Conv.intToByteArray(1, byArray, 4);
        Conv.shortToByteArray(n, byArray, 8);
        Conv.shortToByteArray(2, byArray, 10);
        Conv.intToByteArray(this.pmd_.getRowSize(), byArray, 16);
        int n3 = 20;
        int n4 = 20 + n * 2;
        for (int i = 0; i < n; ++i) {
            Column column = this.pmd_.getColumn(i);
            if (column.isNull()) {
                byArray[n3] = -1;
                byArray[n3 + 1] = -1;
            } else {
                column.convertToBytes(byArray, n4);
            }
            n3 += 2;
            n4 += column.getLength();
        }
        return byArray;
    }

    public void close() throws SQLException {
        if (this.closed_) {
            return;
        }
        DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
        databaseConnection.setSQLCommunicationsAreaCallback(this);
        try {
            if (this.descriptorHandle_ >= 0) {
                databaseConnection.deleteDescriptor(null, this.descriptorHandle_);
            }
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        DatabaseConnection databaseConnection = this.conn_.getDatabaseConnection();
        databaseConnection.setSQLCommunicationsAreaCallback(this);
        DatabaseRequestAttributes databaseRequestAttributes = this.getRequestAttributes();
        databaseRequestAttributes.setPrepareStatementName(this.statementName_);
        if (this.pmd_.getParameterCount() > 0) {
            byte[] byArray = this.getExtendedParameterMarkerData();
            databaseRequestAttributes.setSQLExtendedParameterMarkerData(byArray);
        }
        if (this.statementAttributes_.getSQLStatementType() == 3) {
            databaseRequestAttributes.setSQLStatementType(3);
        }
        try {
            databaseConnection.setCurrentRequestParameterBlockID(this.rpbID_);
            if (this.currentResultSet_ != null) {
                this.currentResultSet_.close();
                this.currentResultSet_ = null;
            }
            this.updateCount_ = 0;
            if (this.descriptorHandle_ < 0) {
                databaseConnection.execute(databaseRequestAttributes);
            } else {
                databaseConnection.execute(databaseRequestAttributes, this.descriptorHandle_);
            }
            this.updateCount_ = this.lastUpdateCount_;
            return this.updateCount_;
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException, this.lastSQLCode_, this.lastSQLState_);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        return this.rsmd_;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        return this.pmd_;
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new NotImplementedException();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setAsciiStreamValue(inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setBinaryStreamValue(inputStream, n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new NotImplementedException();
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setCharacterStreamValue(reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new NotImplementedException();
    }

    public void setDate(int n, Date date) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        if (calendar == null) {
            throw JDBCError.getSQLException("HY105", "cal is null");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(d);
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(f);
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(n2);
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(l);
    }

    public void setNull(int n, int n2) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setNull(true);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setNull(true);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        throw new NotImplementedException();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new NotImplementedException();
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(s);
    }

    public void setString(int n, String string) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(string);
    }

    public void setTime(int n, Time time) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        if (calendar == null) {
            throw JDBCError.getSQLException("HY024", "cal is null");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        if (calendar == null) {
            throw JDBCError.getSQLException("HY024", "cal is null");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(timestamp, calendar);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setUnicodeStreamValue(inputStream, n2);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (this.closed_) {
            throw JDBCError.getSQLException("HY010");
        }
        Column column = this.pmd_.getColumn(n - 1);
        column.setValue(uRL);
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void setClob(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void setNString(int n, String string) throws SQLException {
        throw new NotImplementedException();
    }
}

