/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.components;

import com.ibm.jtopenlite.Message;
import com.ibm.jtopenlite.MessageException;
import com.ibm.jtopenlite.components.UserInfo;
import com.ibm.jtopenlite.components.UserInfoListener;
import com.ibm.jtopenlite.ddm.DDMCallbackEvent;
import com.ibm.jtopenlite.ddm.DDMConnection;
import com.ibm.jtopenlite.ddm.DDMDataBuffer;
import com.ibm.jtopenlite.ddm.DDMFile;
import com.ibm.jtopenlite.ddm.DDMFileMemberDescription;
import com.ibm.jtopenlite.ddm.DDMReadCallback;
import com.ibm.jtopenlite.ddm.DDMRecordFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ListUsersImpl
implements DDMReadCallback,
UserInfoListener {
    private DDMRecordFormat rf_;
    private UserInfoListener uiListener_;
    private final ArrayList<UserInfo> users_ = new ArrayList();
    private boolean done_ = false;

    ListUsersImpl() {
    }

    public void setUserInfoListener(UserInfoListener userInfoListener) {
        this.uiListener_ = userInfoListener;
    }

    public void totalRecords(long l) {
    }

    public void newUserInfo(UserInfo userInfo) {
        this.users_.add(userInfo);
    }

    public void newRecord(DDMCallbackEvent dDMCallbackEvent, DDMDataBuffer dDMDataBuffer) throws IOException {
        byte[] byArray = dDMDataBuffer.getRecordDataBuffer();
        String string = this.rf_.getField("UPUPRF").getString(byArray);
        String string2 = this.rf_.getField("UPUSCL").getString(byArray);
        String string3 = this.rf_.getField("UPPWEX").getString(byArray);
        long l = this.rf_.getField("UPMXST").getLong(byArray);
        long l2 = this.rf_.getField("UPMXSU").getLong(byArray);
        String string4 = this.rf_.getField("UPTEXT").getString(byArray);
        String string5 = this.rf_.getField("UPUPLK").getString(byArray);
        String string6 = this.rf_.getField("UPUPDM").getString(byArray);
        String string7 = this.rf_.getField("UPSTAT").getString(byArray);
        long l3 = this.rf_.getField("UPUID").getLong(byArray);
        long l4 = this.rf_.getField("UPGID").getLong(byArray);
        UserInfo userInfo = new UserInfo(string, string2, string3, l, l2, string4, string5, string6, string7, l3, l4);
        this.uiListener_.newUserInfo(userInfo);
    }

    public void recordNotFound(DDMCallbackEvent dDMCallbackEvent) {
        this.done_ = true;
    }

    public void endOfFile(DDMCallbackEvent dDMCallbackEvent) {
        this.done_ = true;
    }

    private boolean done() {
        return this.done_;
    }

    public UserInfo[] getUsers(DDMConnection dDMConnection) throws IOException {
        List<Message> list = dDMConnection.executeReturnMessageList("DSPUSRPRF USRPRF(*ALL) TYPE(*BASIC) OUTPUT(*OUTFILE) OUTFILE(QTEMP/TBALLUSERS)");
        if (list.size() > 0 && list.size() != 1 && !list.get(0).getID().equals("CPF9861")) {
            throw new MessageException("Error retrieving users: ", list);
        }
        this.users_.clear();
        if (this.rf_ == null) {
            this.rf_ = dDMConnection.getRecordFormat("QTEMP", "TBALLUSERS");
            this.rf_.getField("UPUSCL").setCacheStrings(true);
            this.rf_.getField("UPPWEX").setCacheStrings(true);
            this.rf_.getField("UPUPLK").setCacheStrings(true);
            this.rf_.getField("UPUPDM").setCacheStrings(true);
            this.rf_.getField("UPSTAT").setCacheStrings(true);
        }
        this.done_ = false;
        DDMFile dDMFile = dDMConnection.open("QTEMP", "TBALLUSERS", "TBALLUSERS", "QSYDSUPB", 0, false, 160, 1);
        List<DDMFileMemberDescription> list2 = dDMConnection.getFileMemberDescriptions(dDMFile);
        if (list2 != null && list2.size() > 0) {
            this.uiListener_.totalRecords(list2.get(0).getRecordCount());
        }
        while (!this.done()) {
            dDMConnection.readNext(dDMFile, this);
        }
        dDMConnection.close(dDMFile);
        UserInfo[] userInfoArray = new UserInfo[this.users_.size()];
        return this.users_.toArray(userInfoArray);
    }
}

