/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command.program.journal;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.command.program.CallServiceProgramParameterFormat;
import com.ibm.jtopenlite.command.program.CallServiceProgramProcedure;
import com.ibm.jtopenlite.command.program.journal.RetrieveJournalReceiverInformationListener;

public class RetrieveJournalReceiverInformation
extends CallServiceProgramProcedure
implements CallServiceProgramParameterFormat {
    public static final String FORMAT_RRCV0100 = "RRCV0100";
    private int inputLength_ = 512;
    private String receiverName_;
    private String receiverLibrary_;
    private String formatName_ = "RRCV0100";
    private RetrieveJournalReceiverInformationListener listener_;
    private final char[] charBuffer_ = new char[30];

    public RetrieveJournalReceiverInformation() {
        super("QJOURNAL", "QSYS", "QjoRtvJrnReceiverInformation", 0);
        this.setParameterFormat(this);
    }

    public RetrieveJournalReceiverInformation(String string, String string2, RetrieveJournalReceiverInformationListener retrieveJournalReceiverInformationListener) {
        this(512, string, string2, FORMAT_RRCV0100, retrieveJournalReceiverInformationListener);
    }

    public RetrieveJournalReceiverInformation(int n, String string, String string2, String string3, RetrieveJournalReceiverInformationListener retrieveJournalReceiverInformationListener) {
        this();
        this.inputLength_ = n < 13 ? 13 : n;
        this.receiverName_ = string;
        this.receiverLibrary_ = string2;
        this.formatName_ = string3;
        this.listener_ = retrieveJournalReceiverInformationListener;
    }

    public int getParameterCount() {
        return 5;
    }

    public int getParameterLength(int n) {
        switch (n) {
            case 0: {
                return this.inputLength_;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    public int getParameterFormat(int n) {
        return 2;
    }

    public void fillInputData(int n, byte[] byArray, int n2) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                Conv.intToByteArray(this.inputLength_, byArray, n2);
                break;
            }
            case 2: {
                Conv.stringToBlankPadEBCDICByteArray(this.receiverName_, byArray, n2, 10);
                Conv.stringToBlankPadEBCDICByteArray(this.receiverLibrary_, byArray, n2 + 10, 10);
                break;
            }
            case 3: {
                Conv.stringToEBCDICByteArray37(this.formatName_, byArray, n2);
                break;
            }
            case 4: {
                Conv.intToByteArray(0, byArray, n2);
            }
        }
    }

    public void setOutputData(int n, byte[] byArray, int n2) {
        if (n == 0 && this.formatName_.equals(FORMAT_RRCV0100) && this.listener_ != null) {
            String string = Conv.ebcdicByteArrayToString(byArray, n2 + 28, 10, this.charBuffer_);
            String string2 = Conv.ebcdicByteArrayToString(byArray, n2 + 38, 10, this.charBuffer_);
            char c = Conv.ebcdicByteToChar(byArray[n2 + 88]);
            String string3 = Conv.ebcdicByteArrayToString(byArray, n2 + 95, 13, this.charBuffer_);
            String string4 = Conv.ebcdicByteArrayToString(byArray, n2 + 108, 13, this.charBuffer_);
            long l = Conv.zonedDecimalToLong(byArray, n2 + 372, 20);
            long l2 = Conv.zonedDecimalToLong(byArray, n2 + 412, 20);
            long l3 = Conv.zonedDecimalToLong(byArray, n2 + 432, 20);
            this.listener_.newReceiverInfo(this.receiverName_, this.receiverLibrary_, string, string2, l, l2, l3, c, string3, string4);
        }
    }

    public int getLengthOfReceiverVariable() {
        return this.inputLength_;
    }

    public void setLengthOfReceiverVariable(int n) {
        this.inputLength_ = n;
    }

    public String getReceiverName() {
        return this.receiverName_;
    }

    public void setReceiverName(String string) {
        this.receiverName_ = string;
    }

    public String getReceiverLibrary() {
        return this.receiverLibrary_;
    }

    public void setReceiverLibrary(String string) {
        this.receiverLibrary_ = string;
    }

    public String getFormatName() {
        return this.formatName_;
    }

    public void setFormatName(String string) {
        this.formatName_ = string;
    }

    public RetrieveJournalReceiverInformationListener getListener() {
        return this.listener_;
    }

    public void setListener(RetrieveJournalReceiverInformationListener retrieveJournalReceiverInformationListener) {
        this.listener_ = retrieveJournalReceiverInformationListener;
    }
}

