/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.workspace;

import com.ibm.as400.access.QSYSObjectPathName;
import com.remainsoftware.common.util.ServiceUtils;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.QSYSObject;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.SourceMember;
import miworkplace.ui.api.WorkspaceUtil;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WorkspaceStore
implements EventHandler,
IWorkspaceStore {
    private static final String LIBRARY = "library";
    private static final String SHOW_ALL_LIBRARIES = "showAllLibraries";
    private static final String PROPERTY = "property";
    private static final String LIB_TYPE = "*LIB";
    private static final String QSYS_LIB = "/QSYS.LIB";
    private static final String MBR_EXT = ".MBR";
    private static final String LIB_EXT = ".LIB";
    private static final String EMPTY = "";
    private static final String SLASH = "/";
    private static final String SEPARATOR = ":";
    private final String TREEMAP_END = "\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f.\ue07f\ue07f\ue07f";
    private SortedMap<String, IRemoteObject> store = Collections.synchronizedSortedMap(new TreeMap());
    private Debug logger = Debug.getInstance();
    private static IWorkspace workspace;

    public void activate(BundleContext context) {
        this.logger.info((Option)miworkplace.ui.debug.Option.loading, "Activating workspace store service");
    }

    private String composeKey(IConnection connection, String path) {
        return connection.getName() + SEPARATOR + path;
    }

    public void clear() {
        this.store.clear();
    }

    public void clear(IConnection connection) {
        String connectionKey = this.composeKey(connection, EMPTY);
        HashSet<String> keys = new HashSet<String>(this.store.keySet());
        for (String key : keys) {
            if (!key.startsWith(connectionKey)) continue;
            this.store.remove(key);
        }
    }

    public boolean contains(IRemoteObject obj) {
        return this.store.containsKey(this.composeKey(obj.getConnection(), obj.getPath()));
    }

    public IRemoteObject get(IConnection connection, String path) {
        return (IRemoteObject)this.store.get(this.composeKey(connection, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IRemoteObject> getObjects(IRemoteObject library) {
        ArrayList<IRemoteObject> objects = new ArrayList<IRemoteObject>(20);
        String key = this.composeKey(library.getConnection(), library.getPath());
        SortedMap<String, IRemoteObject> sortedMap = this.store;
        synchronized (sortedMap) {
            SortedMap<String, IRemoteObject> subMap = this.store.subMap(key, key + "/\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f.\ue07f\ue07f\ue07f");
            for (Map.Entry<String, IRemoteObject> entry : subMap.entrySet()) {
                if (entry.getKey().endsWith(LIB_EXT) || entry.getKey().endsWith(MBR_EXT)) continue;
                objects.add(entry.getValue());
            }
        }
        return objects;
    }

    public void add(IRemoteObject obj) {
        this.store.put(this.composeKey(obj.getConnection(), obj.getPath()), obj);
    }

    public void remove(IRemoteObject obj) {
        String key = this.composeKey(obj.getConnection(), obj.getPath());
        if (obj.getType() == IRemoteObject.Type.library || obj.getType() == IRemoteObject.Type.file) {
            for (String k : new LinkedList<String>(this.store.keySet())) {
                if (!k.startsWith(key)) continue;
                this.store.remove(key);
            }
        } else {
            this.store.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IRemoteObject> getLibraries(IConnection connection) {
        LinkedList<IRemoteObject> libraries = new LinkedList<IRemoteObject>();
        String key = connection.getName() + ":/QSYS.LIB";
        SortedMap<String, IRemoteObject> sortedMap = this.store;
        synchronized (sortedMap) {
            SortedMap<String, IRemoteObject> subMap = this.store.subMap(key, key + "/\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f.\ue07f\ue07f\ue07f");
            for (Map.Entry<String, IRemoteObject> entry : subMap.entrySet()) {
                if (entry.getValue().getType() != IRemoteObject.Type.library) continue;
                libraries.add(entry.getValue());
            }
        }
        return libraries;
    }

    public IRemoteObject addLibrary(IConnection connection, String libraryName) {
        Assert.isTrue((libraryName != null && !libraryName.trim().isEmpty() ? 1 : 0) != 0, (String)("Invalid library name passed " + libraryName));
        IRemoteObject result = this.get(connection, MessageFormat.format("{0}/{1}{2}", QSYS_LIB, libraryName.toUpperCase(), LIB_EXT));
        if (result != null) {
            return result;
        }
        IFolder libraryFolder = this.createLibraryFolder(connection, libraryName);
        IRemoteObject library = QSYSObject.create((IConnection)connection, (IResource)libraryFolder, (IRemoteObject.Type)IRemoteObject.Type.library, (String)LIB_TYPE, null, (String)EMPTY);
        this.add(library);
        return library;
    }

    public void addLibraries(IConnection connection, List<String> libraries) {
        IFolder qsysFolder = WorkspaceUtil.getQsys(connection);
        IResource[] localLibsBackup = new IResource[]{};
        try {
            localLibsBackup = qsysFolder.members();
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        for (String libraryName : libraries) {
            IFolder libraryFolder = this.createLibraryFolder(connection, libraryName);
            IRemoteObject library = QSYSObject.create((IConnection)connection, (IResource)libraryFolder, (IRemoteObject.Type)IRemoteObject.Type.library, (String)LIB_TYPE, null, (String)EMPTY);
            this.add(library);
        }
        IResource[] iResourceArray = localLibsBackup;
        int n = localLibsBackup.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IResource localLibrary = iResourceArray[n2];
                if (!libraries.contains(localLibrary.getName())) {
                    try {
                        if (FilenameUtils.getBaseName((String)localLibrary.getName()).isBlank()) {
                            this.logger.error("Local library name is blanks??? " + String.valueOf(localLibrary), (Throwable)new RuntimeException("debug stack trace"));
                            break block10;
                        }
                        localLibrary.delete(true, null);
                        QSYSObjectPathName objPathName = new QSYSObjectPathName();
                        try {
                            objPathName.setLibraryName(FilenameUtils.getBaseName((String)localLibrary.getName()));
                        }
                        catch (PropertyVetoException pve) {
                            this.logger.error("Could not get library path from QSYSObjectPathName object.", (Throwable)pve);
                        }
                        this.store.remove(this.composeKey(connection, objPathName.getPath()));
                    }
                    catch (CoreException e) {
                        this.logger.error(MessageFormat.format("Could not delete obsolete local library folder {0}. Error: {1}", localLibrary.getName(), e.getMessage()), (Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }

    private synchronized IFolder createLibraryFolder(IConnection connection, String libraryName) {
        IFolder qsysFolder;
        IProject project = this.getWorkspace().getRoot().getProject("RemoteFileSystem");
        IFolder connFolder = project.getFolder(connection.getName());
        if (!connFolder.exists()) {
            try {
                connFolder.create(false, true, null);
            }
            catch (CoreException ce) {
                this.logger.error(MessageFormat.format("Could not create folder {0} in local filesystem. Error: {1}", connection.getName(), ce.getMessage()), (Throwable)ce);
            }
        }
        if (!(qsysFolder = connFolder.getFolder("QSYS.LIB")).exists()) {
            try {
                qsysFolder.create(false, true, null);
            }
            catch (CoreException e) {
                this.logger.error(MessageFormat.format("Could not create QSYS.LIB folder for {0} in local filesystem. Error: {1}", connection.getName(), e.getMessage()), (Throwable)e);
            }
        }
        IFolder libraryFolder = qsysFolder.getFolder(libraryName + LIB_EXT);
        try {
            libraryFolder.refreshLocal(0, null);
        }
        catch (CoreException e1) {
            this.logger.info((Option)miworkplace.ui.debug.Option.loading, MessageFormat.format("Could not refresh folder {0}. It might not exist.", connection.getName(), e1.getMessage()), (Throwable)e1);
        }
        if (!libraryFolder.exists()) {
            try {
                libraryFolder.create(false, true, null);
                this.getWorkspace().save(false, null);
            }
            catch (CoreException e) {
                this.logger.error("Could not create the libraries in the local filesystem. Error: " + e.getMessage(), (Throwable)e);
            }
        }
        return libraryFolder;
    }

    private void createConnectionFolder(IConnection connection) {
        IProject root = this.getWorkspace().getRoot().getProject("RemoteFileSystem");
        IFolder folder = root.getFolder(connection.getName());
        try {
            if (folder.exists()) {
                folder.delete(true, null);
            }
            folder.create(0, true, null);
            IFolder qsysFolder = folder.getFolder("QSYS.LIB");
            qsysFolder.create(0, true, null);
            workspace.save(true, null);
        }
        catch (CoreException e) {
            this.logger.error("The folder for the connection in the RemoteFileSystem project could not be created. Error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void deleteConnectionFolder(IConnection connection) {
        IProject root = this.getWorkspace().getRoot().getProject("RemoteFileSystem");
        IFolder folder = root.getFolder(connection.getName());
        if (folder.exists()) {
            try {
                folder.delete(true, null);
            }
            catch (CoreException e) {
                this.logger.error("The folder for the connection in the RemoteFileSystem project could not be deleted. Error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/connection/created")) {
            this.createConnectionFolder((IConnection)event.getProperty("org.eclipse.e4.data"));
        } else if (event.getTopic().equals("miworkplace/connection/deleted")) {
            this.deleteConnectionFolder((IConnection)event.getProperty("org.eclipse.e4.data"));
        } else if (event.getTopic().equals("miworkplace/connection/listed/removed")) {
            IRemoteObject library = (IRemoteObject)event.getProperty(LIBRARY);
            this.remove(library);
        } else if (event.getTopic().equals("miworkplace/connection/changed")) {
            String changedProperty;
            IConnection connection = (IConnection)event.getProperty("org.eclipse.e4.data");
            if (event.getProperty(PROPERTY) != null && SHOW_ALL_LIBRARIES.equals(changedProperty = event.getProperty(PROPERTY).toString()) && !connection.showAllLibraries()) {
                List<IRemoteObject> libraries = this.getLibraries(connection);
                for (IRemoteObject library : libraries) {
                    this.remove(library);
                }
            }
        } else if (event.getTopic().equals("miworkplace/object/deleted")) {
            IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
            this.remove(object);
        } else if (event.getTopic().equals("miworkplace/object/created")) {
            IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
            this.add(object);
        }
    }

    public IWorkspace getWorkspace() {
        return WorkspaceStore.getCreateWorkspace();
    }

    public void setWorkspace(IWorkspace workspace) {
        WorkspaceStore.workspace = workspace;
    }

    public IRemoteObject getLibrary(IRemoteObject object) {
        if (object.getType() == IRemoteObject.Type.library) {
            return object;
        }
        if (object instanceof SourceMember) {
            String path = object.getPath();
            path = path.substring(0, path.lastIndexOf(SLASH));
            path = path.substring(0, path.lastIndexOf(SLASH));
            return this.get(object.getConnection(), path);
        }
        String path = object.getPath();
        path = path.substring(0, path.lastIndexOf(SLASH));
        return this.get(object.getConnection(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IRemoteObject> getMembers(IRemoteObject file) {
        ArrayList<IRemoteObject> members = new ArrayList<IRemoteObject>(20);
        String key = this.composeKey(file.getConnection(), file.getPath());
        SortedMap<String, IRemoteObject> sortedMap = this.store;
        synchronized (sortedMap) {
            SortedMap<String, IRemoteObject> subMap = this.store.subMap(key, key + "/\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f\ue07f.\ue07f\ue07f\ue07f");
            for (Map.Entry<String, IRemoteObject> entry : subMap.entrySet()) {
                if (!entry.getKey().endsWith(MBR_EXT)) continue;
                members.add(entry.getValue());
            }
        }
        return members;
    }

    public IRemoteObject getLibrary(IConnection conn, String libraryName) {
        return this.get(conn, MessageFormat.format("{0}/{1}{2}", QSYS_LIB, libraryName, LIB_EXT));
    }

    public SourceFile getSourceFile(IConnection connection, SourceMember member) {
        String path = member.getPath();
        path = path.substring(0, path.lastIndexOf(SLASH));
        return (SourceFile)this.get(connection, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IRemoteObject> getStreamFiles(IConnection connection, String path) {
        ArrayList<IRemoteObject> files = new ArrayList<IRemoteObject>(10);
        Object key = this.composeKey(connection, path);
        if (!path.equals(SLASH)) {
            key = (String)key + SLASH;
        }
        SortedMap<String, IRemoteObject> sortedMap = this.store;
        synchronized (sortedMap) {
            SortedMap<String, IRemoteObject> subMap = this.store.subMap((String)key, (String)key + "\uab65");
            for (Map.Entry<String, IRemoteObject> entry : subMap.entrySet()) {
                if (entry.getKey().indexOf(SLASH, ((String)key).length()) != -1) continue;
                files.add(entry.getValue());
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IRemoteObject> getStreamFilesRecursively(IConnection connection, String path) {
        ArrayList<IRemoteObject> files = new ArrayList<IRemoteObject>(10);
        Object key = this.composeKey(connection, path);
        if (!path.equals(SLASH)) {
            key = (String)key + SLASH;
        }
        SortedMap<String, IRemoteObject> sortedMap = this.store;
        synchronized (sortedMap) {
            SortedMap<String, IRemoteObject> subMap = this.store.subMap((String)key, (String)key + "\uab65");
            for (Map.Entry<String, IRemoteObject> entry : subMap.entrySet()) {
                files.add(entry.getValue());
            }
        }
        return files;
    }

    public IRemoteObject getParentFile(IRemoteObject file) {
        String path = file.getPath();
        String s = path.substring(0, path.lastIndexOf(SLASH));
        return this.get(file.getConnection(), s);
    }

    public List<IRemoteObject> getPathElements(IConnection connection, String path) {
        ArrayList<IRemoteObject> pathElements = new ArrayList<IRemoteObject>();
        IRemoteObject remoteObject = this.get(connection, path);
        if (remoteObject == null) {
            return pathElements;
        }
        pathElements.add(remoteObject);
        while ((remoteObject = this.getParentFile(remoteObject)) != null) {
            pathElements.add(0, remoteObject);
        }
        return pathElements;
    }

    private static IWorkspace getCreateWorkspace() {
        if (workspace == null) {
            workspace = (IWorkspace)ServiceUtils.getOSGiService(WorkspaceUtil.class, IWorkspace.class);
        }
        return workspace;
    }
}

