/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import miworkplace.common.model.LineType;
import miworkplace.ui.api.Position;
import miworkplace.ui.widgets.FieldNameMapper;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FixedTypeFieldName
implements EventHandler {
    private FieldNameMapper mapper = new FieldNameMapper();
    private Label label;

    public FixedTypeFieldName(Composite parent, int style) {
        this.label = new Label(parent, style);
    }

    public FixedTypeFieldName setEventBroker(IEventBroker eventBroker) {
        eventBroker.subscribe("miworkplace/ui/editor/position/changed", (EventHandler)this);
        eventBroker.subscribe("miworkplace/ui/editor/closed", (EventHandler)this);
        return this;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/ui/editor/position/changed")) {
            Position position = (Position)event.getProperty("org.eclipse.e4.data");
            LineType lineType = (LineType)event.getProperty("linetype");
            if (lineType == null) {
                this.clearLabel();
            } else {
                this.updateLabel(lineType, position);
            }
        } else if (event.getTopic().equals("miworkplace/ui/editor/closed")) {
            this.clearLabel();
        }
    }

    private void clearLabel() {
        if (!this.label.isDisposed()) {
            this.label.setText("");
        }
    }

    private void updateLabel(LineType lineType, Position position) {
        String fieldName = this.mapper.get(lineType, position.y);
        if (fieldName == null) {
            this.clearLabel();
        } else if (!this.label.isDisposed()) {
            this.label.setText(fieldName);
        }
    }

    public Control getControl() {
        return this.label;
    }

    public void setLayoutData(Object data) {
        this.label.setLayoutData(data);
    }
}

