/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import com.ibm.as400.access.IFSFile;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.ui.Constants;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;

public class DirectoryLoader
extends Job {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnection connection;
    @Inject
    @Optional
    private StreamFile parentFile;
    @Inject
    @Named(value="miworkplace.ui.source.id")
    private Long sourceId;

    public DirectoryLoader() {
        super(Messages.ui_dirloader_job_title);
        this.setPriority(20);
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.traceEntry((Option)miworkplace.ui.debug.Option.loading, new Object[]{monitor});
        IStatus status = this.doRun(monitor);
        this.logger.traceExit((Option)miworkplace.ui.debug.Option.loading, (Object)status);
        return status;
    }

    private IStatus doRun(IProgressMonitor pMonitor) {
        try {
            IFSFile[] files;
            String parentFilePath = this.parentFile == null ? "/" : this.parentFile.getPath();
            IFSFile[] iFSFileArray = files = new IFSFile(this.connection.getSystem(), parentFilePath).listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFSFile ifsFile = iFSFileArray[n2];
                boolean directory = ifsFile.isDirectory();
                IResource resource = WorkspaceUtil.buildStreamFileResource(this.connection, ifsFile.getAbsolutePath(), directory);
                StreamFile streamFile = new StreamFile(this.connection, resource, IRemoteObject.Type.streamfile, directory);
                this.workspaceStore.add((IRemoteObject)streamFile);
                ++n2;
            }
            if (this.parentFile != null) {
                this.parentFile.setChildrenLoaded(true);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("viewerId", this.sourceId);
            map.put("connection", this.connection.getName());
            map.put("path", parentFilePath);
            this.eventBroker.post("miworkplace/ui/loader/files/loaded", map);
        }
        catch (IOException ioe) {
            this.logger.error(MessageFormat.format("Could not load files for directory {0}. Error: {1}", this.parentFile != null ? this.parentFile.getPath() : null, ioe.getMessage()), (Throwable)ioe);
            return new Status(4, Constants.PLUGIN_ID, String.format(Messages.ui_dirloader_job_error, this.parentFile != null ? this.parentFile.getName() : null), (Throwable)ioe);
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return this.connection.getName().equals(family);
    }
}

