/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.useraction;

import jakarta.inject.Inject;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.Constants;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;

public class UserActionJob
extends Job {
    private Debug logger = Debug.getInstance();
    @Inject
    private IConnectionUtilities connectionUtilities;
    @Inject
    private UISynchronize sync;
    private IConnection connection;
    private String command;
    private String userActionName;

    public UserActionJob(IConnection connection, String userActionName, String command) {
        super(String.format(Messages.ui_useraction_job_name, command));
        this.connection = connection;
        this.userActionName = userActionName;
        this.command = command;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.connectionUtilities.executeRemoteCommand(this.connection, this.command);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.info((String)Messages.ui_useraction_job_title, (String)String.format(Messages.ui_useraction_job_success, UserActionJob.this.userActionName));
                }
            });
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.logger.error((Option)miworkplace.ui.debug.Option.userActions, "The user action could not execute the command successfully. Command: " + this.command, (Throwable)e);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)Messages.ui_useraction_job_title, (String)Messages.ui_useraction_job_error);
                }
            });
            return new Status(4, Constants.PLUGIN_ID, Messages.ui_useraction_job_error, (Throwable)e);
        }
    }

    public boolean belongsTo(Object family) {
        return this.connection.getName().equals(family);
    }
}

