/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.properties;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;

public class PropertiesPart
implements ISelectionListener {
    public static final String ID = "miworkplace.ui.properties.part";
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IObjectPropertiesStore propertiesStore;
    private Composite noResourceLabel;
    private Composite noPropertiesLabel;
    private TableViewer viewer;
    private StackLayout mainLayout;
    private Composite parentComposite;
    private IRemoteObject shownObject;
    private Map<ObjectProperty, Object> properties;

    @Inject
    public PropertiesPart() {
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.parentComposite = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.noResourceLabel = this.buildNoResourceLabel(parent);
        this.noPropertiesLabel = this.buildPropertiesLabel(parent);
        this.buildTableViewer(parent);
        this.selectionService.addSelectionListener((ISelectionListener)this);
        this.showComponents(this.selectionService.getSelection());
    }

    @PreDestroy
    private void dispose() {
        this.selectionService.removeSelectionListener((ISelectionListener)this);
    }

    @Inject
    @Optional
    public void notifiedObjectDescriptionUpdated(@UIEventTopic(value="miworkplace/ui/loader/description/loaded") Event event) {
        IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
        if (object.equals(this.shownObject)) {
            this.showProperties(object);
        }
    }

    private void modifyTable() {
        Table table = this.viewer.getTable();
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText(Messages.ui_properties_col_property);
        col1.setWidth(200);
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setText(Messages.ui_properties_col_value);
        col2.setWidth(100);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ObjectProperty && e2 instanceof ObjectProperty) {
                    return ((ObjectProperty)e1).description().compareTo(((ObjectProperty)e2).description());
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    private void showComponents(Object selection) {
        if (selection == null) {
            this.mainLayout.topControl = this.noResourceLabel;
            this.parentComposite.layout();
        } else if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof IRemoteObject) {
                this.showProperties((IRemoteObject)firstElement);
            } else if (!(firstElement instanceof IConnection)) {
                this.mainLayout.topControl = this.noPropertiesLabel;
                this.parentComposite.layout();
            }
        } else {
            this.mainLayout.topControl = this.noPropertiesLabel;
            this.parentComposite.layout();
        }
    }

    private void showProperties(IConnection connection) {
        this.viewer.setInput((Object)connection);
        this.mainLayout.topControl = this.viewer.getControl();
        this.parentComposite.layout();
    }

    private void showProperties(IRemoteObject object) {
        this.shownObject = object;
        this.properties = this.propertiesStore.get(object, true);
        if (this.properties == null) {
            this.mainLayout.topControl = this.noPropertiesLabel;
            this.parentComposite.layout();
        } else {
            this.viewer.setInput(this.properties);
            this.mainLayout.topControl = this.viewer.getControl();
            this.parentComposite.layout();
        }
    }

    private void buildTableViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.modifyTable();
    }

    private Composite buildPropertiesLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_properties_notavailable);
        return form;
    }

    private Composite buildNoResourceLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_properties_noresselected);
        return form;
    }

    public void selectionChanged(MPart pPart, Object pSelection) {
        this.showComponents(pSelection);
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IConnection) {
                return null;
            }
            if (parent instanceof Map) {
                Map properties = (Map)parent;
                HashSet keys = new HashSet(properties.keySet());
                keys.remove(ObjectProperty.notloaded);
                keys.remove(ObjectProperty.rawchangedate);
                keys.remove(ObjectProperty.rawcreationdate);
                return keys.toArray(new ObjectProperty[keys.size()]);
            }
            return null;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String text = null;
            switch (index) {
                case 0: {
                    text = ((ObjectProperty)obj).description();
                    break;
                }
                case 1: {
                    Object value = PropertiesPart.this.properties.get(obj);
                    if (value == null) break;
                    text = value.toString();
                }
            }
            return text == null ? "" : text;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

